/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.be.MnemonicBlockEntity;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.registration.ReactiveBlockEntityTypes;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MnemonicBlock
extends Block
implements EntityBlock {
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final BooleanProperty CHARGED = BooleanProperty.create((String)"charged");
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    public MnemonicBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWER, (Comparable)Integer.valueOf(0))).setValue((Property)CHARGED, (Comparable)Boolean.valueOf(false))).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWER});
        builder.add(new Property[]{CHARGED});
        builder.add(new Property[]{ACTIVE});
        super.createBlockStateDefinition(builder);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getLevel().getBlockState(context.getClickedPos().below()).is((Block)ReactiveBlocks.VOLT_CELL.get())) {
            return (BlockState)this.defaultBlockState().setValue((Property)CHARGED, (Comparable)Boolean.valueOf(true));
        }
        return this.defaultBlockState();
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof MnemonicBlockEntity) {
            MnemonicBlockEntity m = (MnemonicBlockEntity)be;
            if (!(level.isClientSide || player.isCreative() && !m.hasMemory())) {
                m.stopRecording();
                ItemStack stack = ((BlockItem)ReactiveItems.MNEMONIC_BULB.get()).getDefaultInstance();
                m.saveToItem(stack, (HolderLookup.Provider)level.registryAccess());
                ItemEntity drop = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack);
                drop.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)drop);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new MnemonicBlockEntity(pos, state);
    }

    protected int getSignal(BlockState state, BlockGetter getter, BlockPos pos, Direction direction) {
        return (Integer)state.getValue((Property)POWER);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighbor_block, BlockPos neighbor_pos, boolean moved_by_piston) {
        super.neighborChanged(state, level, pos, neighbor_block, neighbor_pos, moved_by_piston);
        if (level.getBlockState(pos.below()).is((Block)ReactiveBlocks.VOLT_CELL.get()) && !((Boolean)state.getValue((Property)CHARGED)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)CHARGED, (Comparable)Boolean.valueOf(true)), 2);
        } else if (!level.getBlockState(pos.below()).is((Block)ReactiveBlocks.VOLT_CELL.get()) && ((Boolean)state.getValue((Property)CHARGED)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)CHARGED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource source) {
        super.animateTick(state, level, pos, source);
        if (((Boolean)state.getValue((Property)CHARGED)).booleanValue()) {
            ParticleScribe.drawParticleBox(level, (ParticleOptions)ParticleTypes.ELECTRIC_SPARK, AABB.ofSize((Vec3)Vec3.atBottomCenterOf((Vec3i)pos).add(0.0, 1.0, 0.0), (double)1.2, (double)0.4, (double)1.2), 1);
        }
    }

    @Nullable
    public <MnemonicBlockEntity extends BlockEntity> BlockEntityTicker<MnemonicBlockEntity> getTicker(Level level, BlockState state, BlockEntityType<MnemonicBlockEntity> type) {
        if (type == ReactiveBlockEntityTypes.MNEMONIC_BULB.get() && !level.isClientSide) {
            return (l, p, s, b) -> MnemonicBlockEntity.tick(l, p, s, (MnemonicBlockEntity)b);
        }
        return null;
    }
}

