/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.blocks.DisplacedBlock;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import dev.hyperlynx.reactive.util.BlockMoveChecker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class MotionSaltBlock
extends Block {
    public static final BooleanProperty POWERED = ObserverBlock.POWERED;

    public MotionSaltBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
    }

    public void onPlace(BlockState p_60566_, Level level, BlockPos pos, BlockState p_60569_, boolean p_60570_) {
        MotionSaltBlock.causeNeighborToFall(level, pos.below());
        MotionSaltBlock.causeNeighborToFall(level, pos.offset(1, 0, 0));
        MotionSaltBlock.causeNeighborToFall(level, pos.offset(-1, 0, 0));
        MotionSaltBlock.causeNeighborToFall(level, pos.offset(0, 0, 1));
        MotionSaltBlock.causeNeighborToFall(level, pos.offset(0, 0, -1));
        MotionSaltBlock.checkBecomeElectrified(level, pos, pos.below());
    }

    public void neighborChanged(BlockState our_state, Level level, BlockPos salt_pos, Block block, BlockPos neighbor_pos, boolean unknown) {
        if (level.getDirectSignalTo(salt_pos) > 10) {
            level.setBlock(salt_pos, (BlockState)our_state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
        } else if (((Boolean)our_state.getValue((Property)POWERED)).booleanValue()) {
            level.setBlock(salt_pos, (BlockState)our_state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
        }
        MotionSaltBlock.causeNeighborToFall(level, neighbor_pos);
        MotionSaltBlock.checkBecomeElectrified(level, salt_pos, neighbor_pos);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rng) {
        DisplacedBlock.displace(state, pos, (Level)level, 200);
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            DisplacedBlock.displaceWithChain(level.getBlockState(pos.above()), pos.above(), (Level)level, 210, 0, pos);
        }
    }

    private static void causeNeighborToFall(Level level, BlockPos neighbor_pos) {
        if (!level.getBlockState(neighbor_pos.below()).isAir()) {
            return;
        }
        if (BlockMoveChecker.canMakeBlockFall(level, neighbor_pos, level.getBlockState(neighbor_pos))) {
            FallingBlockEntity.fall((Level)level, (BlockPos)neighbor_pos, (BlockState)level.getBlockState(neighbor_pos));
        }
    }

    private static void checkBecomeElectrified(Level level, BlockPos salt_pos, BlockPos neighbor_pos) {
        if (level.getBlockState(neighbor_pos).is((Block)ReactiveBlocks.VOLT_CELL.get()) && salt_pos.below().equals((Object)neighbor_pos)) {
            level.scheduleTick(salt_pos, (Block)ReactiveBlocks.MOTION_SALT_BLOCK.get(), 10);
        }
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return true;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 100;
    }
}

