/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class NoduleBlock
extends DirectionalBlock {
    private final boolean small;
    private static final VoxelShape SMALL_FLOOR_SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)3.0, (double)10.0);
    private static final VoxelShape SMALL_CEILING_SHAPE = Block.box((double)6.0, (double)13.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SMALL_WEST_SHAPE = Block.box((double)0.0, (double)6.0, (double)6.0, (double)3.0, (double)10.0, (double)10.0);
    private static final VoxelShape SMALL_EAST_SHAPE = Block.box((double)13.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape SMALL_NORTH_SHAPE = Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)3.0);
    private static final VoxelShape SMALL_SOUTH_SHAPE = Block.box((double)6.0, (double)6.0, (double)13.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape FLOOR_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0);
    private static final VoxelShape CEILING_SHAPE = Block.box((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape WEST_SHAPE = Block.box((double)0.0, (double)4.0, (double)4.0, (double)6.0, (double)12.0, (double)12.0);
    private static final VoxelShape EAST_SHAPE = Block.box((double)10.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final VoxelShape NORTH_SHAPE = Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)6.0);
    private static final VoxelShape SOUTH_SHAPE = Block.box((double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)12.0, (double)16.0);
    public static final MapCodec<NoduleBlock> CODEC = NoduleBlock.simpleCodec(NoduleBlock::new);

    public NoduleBlock(BlockBehaviour.Properties properties, boolean small_hitbox) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.DOWN));
        this.small = small_hitbox;
    }

    private NoduleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.DOWN));
        this.small = false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        super.createBlockStateDefinition(builder);
    }

    private boolean isSmall() {
        return this.small;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case UP: {
                return this.isSmall() ? SMALL_CEILING_SHAPE : CEILING_SHAPE;
            }
            case WEST: {
                return this.isSmall() ? SMALL_WEST_SHAPE : WEST_SHAPE;
            }
            case EAST: {
                return this.isSmall() ? SMALL_EAST_SHAPE : EAST_SHAPE;
            }
            case NORTH: {
                return this.isSmall() ? SMALL_NORTH_SHAPE : NORTH_SHAPE;
            }
            case SOUTH: {
                return this.isSmall() ? SMALL_SOUTH_SHAPE : SOUTH_SHAPE;
            }
        }
        return this.isSmall() ? SMALL_FLOOR_SHAPE : FLOOR_SHAPE;
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite());
    }
}

