/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.advancements.FlagTrigger;
import dev.hyperlynx.reactive.blocks.SymbolBlock;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.registration.ReactiveCriterionTriggers;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import dev.hyperlynx.reactive.registration.ReactiveParticles;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class OccultSymbolBlock
extends SymbolBlock {
    public static final BooleanProperty ACTIVE = BlockStateProperties.ENABLED;

    public OccultSymbolBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity instanceof ServerPlayer) {
            ((FlagTrigger)((Object)ReactiveCriterionTriggers.PLACE_OCCULT.get())).trigger((ServerPlayer)entity);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ACTIVE});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)Objects.requireNonNull(super.getStateForPlacement(context)).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource source) {
        if (!((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            return;
        }
        double d0 = source.nextDouble() * 8.0 - 4.0;
        double d1 = source.nextDouble() * 8.0 - 4.0;
        double d2 = source.nextDouble() * 8.0 - 4.0;
        level.addParticle((ParticleOptions)ReactiveParticles.SMALL_BLACK_RUNE, (double)pos.getX() + d0, (double)pos.getY() + d1, (double)pos.getZ() + d2, 0.0, 0.0, 0.0);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!player.getItemInHand(hand).is((Item)ReactiveItems.QUARTZ_BOTTLE.get())) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (player.getCooldowns().isOnCooldown((Item)ReactiveItems.QUARTZ_BOTTLE.get())) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        List<Item> bottle_list = List.of((Item)ReactiveItems.ACID_BOTTLE.get(), (Item)ReactiveItems.BODY_BOTTLE.get(), (Item)ReactiveItems.BLAZE_BOTTLE.get(), (Item)ReactiveItems.VERDANT_BOTTLE.get(), (Item)ReactiveItems.LIGHT_BOTTLE.get(), (Item)ReactiveItems.MIND_BOTTLE.get());
        int roll = level.random.nextInt(0, 7);
        boolean bottle_broke = false;
        switch (roll) {
            case 0: {
                player.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 1500, 1));
                player.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 1500, 0));
                player.hurt(level.damageSources().magic(), Math.min(12.0f, player.getHealth() - 1.0f));
                player.displayClientMessage((Component)Component.translatable((String)"message.reactive.extract_acid"), true);
                break;
            }
            case 1: {
                player.addEffect(new MobEffectInstance(MobEffects.HUNGER, 1000, 1));
                player.getFoodData().setFoodLevel(Math.max(0, player.getFoodData().getFoodLevel() - 16));
                player.displayClientMessage((Component)Component.translatable((String)"message.reactive.extract_body"), true);
                break;
            }
            case 2: {
                player.setTicksFrozen(800);
                player.setRemainingFireTicks(0);
                player.hurt(level.damageSources().freeze(), Math.min(5.0f, player.getHealth() - 1.0f));
                player.displayClientMessage((Component)Component.translatable((String)"message.reactive.extract_blaze"), true);
                break;
            }
            case 3: {
                player.addEffect(new MobEffectInstance(MobEffects.POISON, 800, 2));
                player.hurt(level.damageSources().magic(), 2.0f);
                player.displayClientMessage((Component)Component.translatable((String)"message.reactive.extract_verdant"), true);
                break;
            }
            case 4: {
                player.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 1500, 0));
                player.displayClientMessage((Component)Component.translatable((String)"message.reactive.extract_light"), true);
                break;
            }
            case 5: {
                if (player instanceof ServerPlayer) {
                    ServerPlayer splayer = (ServerPlayer)player;
                    ((FlagTrigger)((Object)ReactiveCriterionTriggers.HARVEST.get())).trigger(splayer);
                }
                if (player.experienceLevel > 1) {
                    player.giveExperienceLevels(-1);
                    player.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 150, 2));
                } else {
                    player.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 300, 2));
                }
                player.displayClientMessage((Component)Component.translatable((String)"message.reactive.extract_mind"), true);
                player.playSound(SoundEvents.BELL_RESONATE, 0.8f, 0.8f);
                break;
            }
            default: {
                bottle_broke = true;
            }
        }
        ParticleScribe.drawParticleZigZag(level, (ParticleOptions)ReactiveParticles.SMALL_BLACK_RUNE, pos, player.blockPosition().above(), 5, 4, 0.7);
        player.getItemInHand(hand).shrink(1);
        if (bottle_broke) {
            player.displayClientMessage((Component)Component.translatable((String)"message.reactive.bottle_broke"), true);
            player.hurt(level.damageSources().generic(), 1.0f);
            level.playSound(null, pos, SoundEvents.GLASS_BREAK, SoundSource.PLAYERS, 0.5f, 1.0f);
        } else {
            ItemStack bottled_power = bottle_list.get(roll).getDefaultInstance();
            player.addItem(bottled_power);
            level.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.PLAYERS, 1.0f, 0.8f);
        }
        if (!player.getAbilities().instabuild) {
            player.getCooldowns().addCooldown((Item)ReactiveItems.QUARTZ_BOTTLE.get(), 80);
        }
        return ItemInteractionResult.SUCCESS;
    }
}

