/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.blocks.WaterloggableBlock;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class PowerBottleBlock
extends WaterloggableBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final IntegerProperty BOTTLES = IntegerProperty.create((String)"bottles", (int)1, (int)3);

    public PowerBottleBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)Direction.Axis.X)).setValue((Property)BOTTLES, (Comparable)Integer.valueOf(1)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS});
        builder.add(new Property[]{BOTTLES});
        super.createBlockStateDefinition(builder);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)Objects.requireNonNull(super.getStateForPlacement(context)).setValue(AXIS, (Comparable)context.getHorizontalDirection().getAxis());
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int bottles = (Integer)state.getValue((Property)BOTTLES);
        if (bottles == 1) {
            return PowerBottleBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0);
        }
        if (((Direction.Axis)state.getValue(AXIS)).equals((Object)Direction.Axis.X)) {
            if (bottles == 2) {
                return PowerBottleBlock.box((double)6.0, (double)0.0, (double)3.0, (double)10.0, (double)8.0, (double)13.0);
            }
            return PowerBottleBlock.box((double)6.0, (double)0.0, (double)1.0, (double)10.0, (double)8.0, (double)15.0);
        }
        if (bottles == 2) {
            return PowerBottleBlock.box((double)3.0, (double)0.0, (double)6.0, (double)13.0, (double)8.0, (double)10.0);
        }
        return PowerBottleBlock.box((double)1.0, (double)0.0, (double)6.0, (double)15.0, (double)8.0, (double)10.0);
    }
}

