/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.alchemy.AlchemyTags;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.blocks.CrucibleBlock;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ShulkerCrucibleBlock
extends CrucibleBlock {
    public ShulkerCrucibleBlock(BlockBehaviour.Properties p) {
        super(p);
    }

    @NotNull
    private static ItemStack getDropStack(Level level, @NotNull BlockPos pos, @NotNull BlockState state, CrucibleBlockEntity crucible) {
        ItemStack drop_stack = ((BlockItem)ReactiveItems.SHULKER_CRUCIBLE.get()).getDefaultInstance();
        if (crucible.getTotalPowerLevel() > 0) {
            crucible.saveToItem(drop_stack, (HolderLookup.Provider)level.registryAccess());
            drop_stack.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.literal((String)ShulkerCrucibleBlock.getItemLabel(crucible)))));
        } else if (((Boolean)state.getValue((Property)FULL)).booleanValue()) {
            level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 0.6f, 0.8f);
        }
        return drop_stack;
    }

    private static String getItemLabel(CrucibleBlockEntity crucible) {
        StringBuilder label = new StringBuilder();
        for (Power p : crucible.getPowerMap().keySet()) {
            if (crucible.getPowerLevel(p) <= 0) continue;
            label.append(p.getName()).append(", ");
        }
        return label.substring(0, label.length() - 2);
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState new_state, boolean p_60519_) {
        BlockEntity be = level.getBlockEntity(pos);
        if (!new_state.is(ReactiveBlocks.SHULKER_CRUCIBLE) && !new_state.is(AlchemyTags.crucibleCanBecome) && be instanceof CrucibleBlockEntity) {
            CrucibleBlockEntity crucible = (CrucibleBlockEntity)be;
            if (!level.isClientSide) {
                ItemEntity drop = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, ShulkerCrucibleBlock.getDropStack(level, pos, state, crucible));
                drop.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)drop);
            }
        }
        super.onRemoveWithoutEmpty(state, level, pos, new_state, p_60519_);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState old_state, boolean p_60570_) {
        BlockEntity recently_placed_be = level.getBlockEntity(pos);
        if (!(recently_placed_be instanceof CrucibleBlockEntity)) {
            return;
        }
        CrucibleBlockEntity crucible = (CrucibleBlockEntity)recently_placed_be;
        if (old_state.getBlock() instanceof ShulkerCrucibleBlock) {
            return;
        }
        level.setBlock(pos, (BlockState)state.setValue((Property)FULL, (Comparable)Boolean.valueOf(crucible.getTotalPowerLevel() > 0)), 11);
    }
}

