/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.client;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.blocks.MaterialBlock;
import dev.hyperlynx.reactive.client.gui.DeskScreen;
import dev.hyperlynx.reactive.client.models.HoverQuiltModel;
import dev.hyperlynx.reactive.client.particles.AcidBubbleParticle;
import dev.hyperlynx.reactive.client.particles.EnergyParticle;
import dev.hyperlynx.reactive.client.particles.RuneParticle;
import dev.hyperlynx.reactive.client.particles.SmallBlackRuneParticle;
import dev.hyperlynx.reactive.client.particles.SmallRuneParticle;
import dev.hyperlynx.reactive.client.particles.StardustParticle;
import dev.hyperlynx.reactive.client.renderers.be.CrucibleRenderer;
import dev.hyperlynx.reactive.client.renderers.be.GatewayRenderer;
import dev.hyperlynx.reactive.client.renderers.be.SymbolRenderer;
import dev.hyperlynx.reactive.client.renderers.entities.HoverQuiltRenderer;
import dev.hyperlynx.reactive.client.renderers.entities.ReactorEntityRenderer;
import dev.hyperlynx.reactive.integration.iris.IrisGatewayRenderer;
import dev.hyperlynx.reactive.integration.ponder.ReactivePonderPlugin;
import dev.hyperlynx.reactive.items.MaterialItem;
import dev.hyperlynx.reactive.registration.ReactiveBlockEntityTypes;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import dev.hyperlynx.reactive.registration.ReactiveEntityTypes;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import dev.hyperlynx.reactive.registration.ReactiveMenus;
import dev.hyperlynx.reactive.registration.ReactiveParticles;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;

public class ClientRegistration {
    public static boolean IRIS_MODE = false;

    public static void init(IEventBus bus) {
        bus.register(ClientRegistration.class);
        if (ModList.get().isLoaded("iris") || ModList.get().isLoaded("oculus")) {
            IRIS_MODE = true;
        }
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent evt) {
        Minecraft.getInstance().particleEngine.register((ParticleType)ReactiveParticles.STARDUST_PARTICLE_TYPE.get(), StardustParticle.StardustParticleProvider::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)ReactiveParticles.RUNE_PARTICLE_TYPE.get(), RuneParticle.RuneParticleProvider::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)ReactiveParticles.SMALL_RUNE_PARTICLE_TYPE.get(), SmallRuneParticle.SmallRuneParticleProvider::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)ReactiveParticles.SMALL_BLACK_RUNE_PARTICLE_TYPE.get(), SmallBlackRuneParticle.SmallBlackRuneParticleProvider::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)ReactiveParticles.ACID_BUBBLE_PARTICLE_TYPE.get(), AcidBubbleParticle.AcidBubbleParticleProvider::new);
        evt.registerSpriteSet((ParticleType)ReactiveParticles.ENERGY_PARTICLE_TYPE.get(), EnergyParticle.Provider::new);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ReactiveBlockEntityTypes.CRUCIBLE.get(), CrucibleRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ReactiveBlockEntityTypes.SYMBOL.get(), SymbolRenderer::new);
        if (IRIS_MODE && ((Boolean)ConfigMan.CLIENT.irisCompat.get()).booleanValue()) {
            event.registerBlockEntityRenderer((BlockEntityType)ReactiveBlockEntityTypes.GATEWAY.get(), IrisGatewayRenderer::new);
        } else {
            event.registerBlockEntityRenderer((BlockEntityType)ReactiveBlockEntityTypes.GATEWAY.get(), GatewayRenderer::new);
        }
        event.registerEntityRenderer(ReactiveEntityTypes.REACTOR.get(), ReactorEntityRenderer::new);
        event.registerEntityRenderer(ReactiveEntityTypes.THROWN_REACTION_FLASK.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer(ReactiveEntityTypes.HOVER_QUILT.get(), HoverQuiltRenderer::new);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(HoverQuiltModel.LAYER_LOCATION, HoverQuiltModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void onClientSetupEvent(FMLClientSetupEvent evt) {
        if (ModList.get().isLoaded("ponder")) {
            ReactivePonderPlugin.clientInit();
        }
        ItemProperties.register((Item)((Item)ReactiveItems.MATERIAL.get()), (ResourceLocation)ReactiveMod.location("material_model_index"), MaterialItem::getModelOverrideValue);
    }

    @SubscribeEvent
    public static void registerBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        event.register((state, getter, pos, index) -> {
            assert (getter != null);
            return MaterialBlock.getBlockColor(getter, pos);
        }, new Block[]{(Block)ReactiveBlocks.MATERIAL_BLOCK.get()});
    }

    @SubscribeEvent
    public static void registerItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        event.register(MaterialItem::getItemColor, new ItemLike[]{(ItemLike)ReactiveItems.MATERIAL.get()});
    }

    @SubscribeEvent
    public static void registerMenuScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)ReactiveMenus.DESK_MENU.get(), DeskScreen::new);
    }
}

