/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.client.gui;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.material.Material;
import dev.hyperlynx.reactive.alchemy.material.MaterialMan;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperty;
import dev.hyperlynx.reactive.client.gui.BetterFittingMultiLineTextWidget;
import dev.hyperlynx.reactive.client.gui.ScreenOpener;
import dev.hyperlynx.reactive.menu.DeskMenu;
import dev.hyperlynx.reactive.registration.ReactiveComponentTypes;
import dev.hyperlynx.reactive.util.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class DeskScreen
extends AbstractContainerScreen<DeskMenu> {
    private static final ResourceLocation DESK_BACKGROUND_LOCATION = ReactiveMod.location("textures/gui/discovery_desk.png");
    private static final ResourceLocation VIEW_DISCOVERIES_BUTTON = ReactiveMod.location("discoveries_tab");
    private static final ResourceLocation VIEW_DISCOVERIES_BUTTON_INACTIVE = ReactiveMod.location("discoveries_tab_inactive");
    private static final ResourceLocation VIEW_DISCOVERIES_BUTTON_FOCUSED = ReactiveMod.location("discoveries_tab_focused");
    final Button rename_button = new Button.Builder((Component)Component.empty(), button -> {
        ItemStack stack;
        ResourceLocation location;
        if (((DeskMenu)this.getMenu()).getSlot(0).hasItem() && (location = (ResourceLocation)(stack = ((DeskMenu)this.getMenu()).getSlot(0).getItem()).get((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get())) != null) {
            ScreenOpener.materialRename(location);
        }
    }).build();
    final Button discoveries_button = new ImageButton(20, 20, new WidgetSprites(VIEW_DISCOVERIES_BUTTON, VIEW_DISCOVERIES_BUTTON_INACTIVE, VIEW_DISCOVERIES_BUTTON_FOCUSED), button -> ScreenOpener.materialList(), (Component)Component.empty());
    BetterFittingMultiLineTextWidget readout;
    int slot_x;
    int slot_y;
    ResourceLocation last_material = ReactiveMod.location("null");
    private static final List<Rect> DECORATIONS = List.of(new Rect(21, 20, 46, 20), new Rect(21, 45, 46, 45), new Rect(21, 20, 21, 45), new Rect(46, 20, 46, 45));

    public DeskScreen(DeskMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void init() {
        super.init();
        this.slot_x = ((DeskMenu)this.getMenu()).getSlot((int)0).x + this.getGuiLeft();
        this.slot_y = ((DeskMenu)this.getMenu()).getSlot((int)0).y + this.getGuiTop();
        this.rename_button.visible = false;
        this.rename_button.active = false;
        this.rename_button.setPosition(this.slot_x - 16, this.slot_y + 24);
        this.rename_button.setWidth(51);
        this.addRenderableWidget((GuiEventListener)this.rename_button);
        this.discoveries_button.setPosition(this.getGuiLeft() + 150, this.getGuiTop() - 17);
        this.addRenderableWidget((GuiEventListener)this.discoveries_button);
        this.readout = null;
    }

    private Material getMaterial() {
        return MaterialMan.fetch((Level)Minecraft.getInstance().level, this.getMaterialId());
    }

    private ResourceLocation getMaterialId() {
        ItemStack stack = ((DeskMenu)this.getMenu()).getSlot(0).getItem();
        if (!stack.has((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get())) {
            return null;
        }
        return (ResourceLocation)stack.get((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get());
    }

    protected void containerTick() {
        this.rename_button.active = false;
        this.rename_button.visible = false;
        this.rename_button.setTooltip(null);
        if (((DeskMenu)this.getMenu()).getSlot(0).hasItem()) {
            Material material = this.getMaterial();
            if (material != null) {
                this.updateButton(material);
                ResourceLocation material_id = this.getMaterialId();
                if (material_id != null) {
                    this.updateReadout(material, material_id);
                }
            }
        } else {
            if (this.readout != null) {
                this.removeWidget((GuiEventListener)this.readout);
                this.last_material = ReactiveMod.location("null");
            }
            this.readout = null;
        }
    }

    private void updateButton(Material material) {
        this.rename_button.visible = true;
        if (material.wasDiscovered()) {
            this.rename_button.setMessage((Component)Component.translatable((String)"ui.reactive.rename_button"));
            if (material.playerDiscoveredThis((Player)Minecraft.getInstance().player)) {
                this.rename_button.active = true;
            } else {
                this.rename_button.setTooltip(Tooltip.create((Component)Component.translatable((String)"text.reactive.cannot_rename_others_discovery")));
            }
        } else {
            this.rename_button.setMessage((Component)Component.translatable((String)"ui.reactive.discover_button"));
            this.rename_button.active = true;
        }
    }

    private void updateReadout(Material material, ResourceLocation material_id) {
        if (material_id.equals((Object)this.last_material) && this.readout != null) {
            return;
        }
        this.last_material = material_id;
        if (this.readout != null) {
            this.removeWidget((GuiEventListener)this.readout);
        }
        this.readout = new BetterFittingMultiLineTextWidget(this.slot_x + 39, this.slot_y - 6, 104, 60, (Component)material.formulaComponent(), Minecraft.getInstance().font);
        this.addRenderableWidget((GuiEventListener)this.readout);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(DESK_BACKGROUND_LOCATION, i, j, 0, 0, this.imageWidth, this.imageHeight);
        this.renderDecorations(guiGraphics);
    }

    private void renderDecorations(GuiGraphics graphics) {
        if (this.getMaterialId() == null) {
            return;
        }
        Color color = (Color)this.getMaterial().get((MaterialProperty)MaterialProperties.COLOR.get());
        if (color == null) {
            return;
        }
        for (Rect rect : DECORATIONS) {
            graphics.fill(rect.x1 + this.getGuiLeft(), rect.y1 + this.getGuiTop(), rect.x2 + this.getGuiLeft() + 1, rect.y2 + this.getGuiTop() + 1, 0xFF000000 | color.hex);
        }
    }

    private record Rect(int x1, int y1, int x2, int y2) {
    }
}

