/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.client.gui;

import dev.hyperlynx.reactive.alchemy.material.ClientMaterialMan;
import dev.hyperlynx.reactive.alchemy.material.Material;
import dev.hyperlynx.reactive.client.gui.BetterFittingMultiLineTextWidget;
import dev.hyperlynx.reactive.items.MaterialItem;
import dev.hyperlynx.reactive.registration.ReactiveComponentTypes;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MaterialListScreen
extends Screen {
    MaterialsList list_panel;
    BetterFittingMultiLineTextWidget formula_box;
    boolean notes_initialized = false;
    MaterialEntry last_selection = null;

    protected MaterialListScreen() {
        super((Component)Component.translatable((String)"ui.reactive.material_list"));
    }

    protected void init() {
        super.init();
        this.list_panel = new MaterialsList(Minecraft.getInstance(), 165, this.getRectangle().height() - 40, 10, 32);
        this.list_panel.setPosition(this.getRectangle().getCenterInAxis(ScreenAxis.HORIZONTAL) - 165, this.getRectangle().top() + 20);
        this.addRenderableWidget((GuiEventListener)this.list_panel);
        this.formula_box = new BetterFittingMultiLineTextWidget(this.getRectangle().getCenterInAxis(ScreenAxis.HORIZONTAL) + 25, this.getRectangle().top() + 20, 150, this.getRectangle().height() - 40, (Component)Component.empty(), this.getMinecraft().font);
        this.formula_box.visible = false;
        this.addRenderableWidget((GuiEventListener)this.formula_box);
    }

    public void tick() {
        super.tick();
        MaterialEntry selection = (MaterialEntry)this.list_panel.getSelected();
        if (selection == null) {
            this.formula_box.visible = false;
            this.removeWidget((GuiEventListener)this.formula_box);
            this.notes_initialized = false;
        } else if (selection != this.last_selection) {
            if (this.notes_initialized) {
                this.removeWidget((GuiEventListener)this.formula_box);
            }
            MutableComponent formula = selection.material.formulaComponent();
            int max_width = 0;
            int max_height = 0;
            for (String line : formula.getString().lines().toList()) {
                int width = Minecraft.getInstance().font.width(line);
                if (max_width < width) {
                    max_width = width;
                }
                Objects.requireNonNull(Minecraft.getInstance().font);
                max_height += 9;
            }
            this.formula_box = new BetterFittingMultiLineTextWidget(this.formula_box.getX(), this.formula_box.getY(), max_width + this.formula_box.getInnerPadding() * 2, max_height + this.formula_box.getInnerPadding() * 2, (Component)selection.material.formulaComponent(), Minecraft.getInstance().font);
            this.formula_box.visible = true;
            this.addRenderableWidget((GuiEventListener)this.formula_box);
            this.notes_initialized = true;
            this.last_selection = selection;
        }
    }

    static class MaterialEntry
    extends ObjectSelectionList.Entry<MaterialEntry>
    implements GuiEventListener {
        final ResourceLocation material_id;
        final Material material;
        boolean focused = false;

        public MaterialEntry(ResourceLocation material_id) {
            this.material_id = material_id;
            this.material = ClientMaterialMan.data().get(material_id);
        }

        public void setFocused(boolean focused) {
            this.focused = focused;
        }

        public boolean isFocused() {
            return this.focused;
        }

        public void render(@NotNull GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            ItemStack dummy_stack = ((MaterialItem)((Object)ReactiveItems.MATERIAL.get())).getDefaultInstance();
            dummy_stack.set((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get(), (Object)this.material_id);
            int top_line = top + 4;
            graphics.renderFakeItem(dummy_stack, left + 4, top_line + 2);
            graphics.drawString(Minecraft.getInstance().font, ClientMaterialMan.getName(this.material_id), left + 24, top_line, -1);
            graphics.drawString(Minecraft.getInstance().font, this.material.getDiscovererName((Level)Minecraft.getInstance().level), left + 24, top_line + 12, -1);
        }

        @NotNull
        public Component getNarration() {
            return this.material.getNameComponent();
        }
    }

    private static class MaterialsList
    extends ObjectSelectionList<MaterialEntry> {
        public MaterialsList(Minecraft client, int width, int height, int y, int item_height) {
            super(client, width, height, y, item_height);
            for (ResourceLocation material_id : ClientMaterialMan.getKeysInDiscoveryOrder()) {
                if (!ClientMaterialMan.data().get(material_id).wasDiscovered()) continue;
                this.addEntry((AbstractSelectionList.Entry)new MaterialEntry(material_id));
            }
        }

        public int getRowWidth() {
            return 165;
        }
    }
}

