/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.client.particles;

import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RuneParticle
extends TextureSheetParticle {
    static final Random RANDOM = new Random();
    private final SpriteSet sprites;
    protected float base_size;

    protected RuneParticle(ClientLevel level, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, SpriteSet pSprites) {
        super(level, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
        this.sprites = pSprites;
        this.friction = 0.95f;
        this.speedUpWhenYMotionIsBlocked = true;
        this.hasPhysics = false;
        this.age = RANDOM.nextInt(0, 5);
        this.setSpriteFromAge(this.sprites);
        this.base_size = 1.2f;
    }

    public int getLightColor(float p_172146_) {
        float f = ((float)this.age + p_172146_) / (float)this.lifetime;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        int i = super.getLightColor(p_172146_);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
        this.setSize(this.base_size - (float)this.age / (float)this.lifetime, this.base_size - (float)this.age / (float)this.lifetime);
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class RuneParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public RuneParticleProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Nullable
        public Particle createParticle(@NotNull SimpleParticleType pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            RuneParticle particle = new RuneParticle(pLevel, pX, pY, pZ, 0.0, 0.0, 0.0, this.sprite);
            particle.setColor(RANDOM.nextFloat(0.8f, 1.0f), RANDOM.nextFloat(0.6f, 1.0f), RANDOM.nextFloat(0.8f, 1.0f));
            particle.setParticleSpeed(0.0, -0.01, 0.0);
            particle.setLifetime(RANDOM.nextInt(20, 50));
            return particle;
        }
    }
}

