/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.client.renderers.be;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.blocks.CrucibleBlock;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.client.renderers.rxn.ReactorRenderer;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import dev.hyperlynx.reactive.util.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class CrucibleRenderer
implements BlockEntityRenderer<CrucibleBlockEntity>,
ReactorRenderer {
    private final BlockRenderDispatcher blockRenderDispatcher;

    public CrucibleRenderer(BlockEntityRendererProvider.Context context) {
        this.blockRenderDispatcher = context.getBlockRenderDispatcher();
    }

    private TextureAtlasSprite getSprite(CrucibleBlockEntity crucible) {
        if (((Boolean)ConfigMan.CLIENT.doNotChangeWaterTexture.get()).booleanValue()) {
            return this.blockRenderDispatcher.getBlockModel(Blocks.WATER.defaultBlockState()).getParticleIcon(ModelData.EMPTY);
        }
        if (crucible.integrity < 20 && crucible.integrity > 8) {
            return this.blockRenderDispatcher.getBlockModel(((Block)ReactiveBlocks.DUMMY_NOISE_WATER.get()).defaultBlockState()).getParticleIcon(ModelData.EMPTY);
        }
        int threshold = 800;
        if (crucible.getTotalPowerLevel() > threshold) {
            Power max_power = null;
            int max_level = 0;
            for (Power power : crucible.getPowerMap().keySet()) {
                if (power.invisible || crucible.getPowerLevel(power) <= max_level) continue;
                max_power = power;
                max_level = crucible.getPowerLevel(power);
            }
            if (max_level > threshold) {
                return this.blockRenderDispatcher.getBlockModel(max_power.getWaterRenderBlock().defaultBlockState()).getParticleIcon(ModelData.EMPTY);
            }
        }
        return this.blockRenderDispatcher.getBlockModel(Blocks.WATER.defaultBlockState()).getParticleIcon(ModelData.EMPTY);
    }

    private void renderElectricity(CrucibleBlockEntity crucible) {
        float speedDivisor = 27.0f;
        if (crucible.electricCharge > 0) {
            ParticleScribe.drawParticleCrucibleTop(Objects.requireNonNull(crucible.getLevel()), (ParticleOptions)ParticleTypes.ELECTRIC_SPARK, crucible.getBlockPos(), 0.05f, ((double)crucible.getLevel().random.nextFloat() - 0.5) / (double)speedDivisor, ((double)crucible.getLevel().random.nextFloat() - 0.5) / (double)speedDivisor, ((double)crucible.getLevel().random.nextFloat() - 0.5) / (double)speedDivisor);
        }
    }

    private void renderSculkCharge(CrucibleBlockEntity crucible) {
        float speedDivisor = 27.0f;
        if (!crucible.sculkSpreader.getCursors().isEmpty()) {
            ParticleScribe.drawParticleCrucibleTop(Objects.requireNonNull(crucible.getLevel()), (ParticleOptions)ParticleTypes.SCULK_SOUL, crucible.getBlockPos(), 0.05f, ((double)crucible.getLevel().random.nextFloat() - 0.5) / (double)speedDivisor, ((double)crucible.getLevel().random.nextFloat() - 0.5) / (double)speedDivisor, ((double)crucible.getLevel().random.nextFloat() - 0.5) / (double)speedDivisor);
        }
    }

    public void render(@NotNull CrucibleBlockEntity crucible, float partialTicks, PoseStack pose_stack, @NotNull MultiBufferSource buffer_source, int light, int overlay) {
        pose_stack.pushPose();
        pose_stack.translate(0.0, 0.5625, 0.0);
        pose_stack.mulPose(Axis.XP.rotationDegrees(90.0f));
        if (((Boolean)crucible.getBlockState().getValue((Property)CrucibleBlock.FULL)).booleanValue()) {
            TextureAtlasSprite sprite = this.getSprite(crucible);
            Color color = crucible.getCombinedColor(BiomeColors.getAverageWaterColor((BlockAndTintGetter)((BlockAndTintGetter)Objects.requireNonNull(crucible.getLevel())), (BlockPos)crucible.getBlockPos()));
            VertexConsumer consumer = buffer_source.getBuffer(Sheets.translucentCullBlockSheet());
            CrucibleRenderer.renderIcon(pose_stack, consumer, sprite, color, crucible.getOpacity(), overlay, light);
            if (crucible.getPowerLevel((Power)Powers.ASTRAL_POWER.get()) > 0) {
                pose_stack.translate(0.0, 0.0, 0.05);
                consumer = buffer_source.getBuffer(RenderType.endPortal());
                CrucibleRenderer.renderEndPortalWater(pose_stack, consumer, overlay, light);
            }
        }
        pose_stack.popPose();
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        this.renderReactions(crucible);
        this.renderElectricity(crucible);
        this.renderSculkCharge(crucible);
    }

    public static void renderIcon(PoseStack ms, VertexConsumer builder, TextureAtlasSprite sprite, Color color, float alpha, int overlay, int light) {
        Matrix4f mat = ms.last().pose();
        builder.addVertex(mat, 0.19f, 0.81f, 0.0f).setColor(color.red, color.green, color.blue, (int)(alpha * 255.0f)).setUv(sprite.getU0(), sprite.getV1()).setOverlay(overlay).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(mat, 0.81f, 0.81f, 0.0f).setColor(color.red, color.green, color.blue, (int)(alpha * 255.0f)).setUv(sprite.getU1(), sprite.getV1()).setOverlay(overlay).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(mat, 0.81f, 0.19f, 0.0f).setColor(color.red, color.green, color.blue, (int)(alpha * 255.0f)).setUv(sprite.getU1(), sprite.getV0()).setOverlay(overlay).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(mat, 0.19f, 0.19f, 0.0f).setColor(color.red, color.green, color.blue, (int)(alpha * 255.0f)).setUv(sprite.getU0(), sprite.getV0()).setOverlay(overlay).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
    }

    public static void renderEndPortalWater(PoseStack pose_stack, VertexConsumer consumer, int overlay, int light) {
        Matrix4f pose = pose_stack.last().pose();
        consumer.addVertex(pose, 0.19f, 0.81f, 0.0f).setOverlay(overlay).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
        consumer.addVertex(pose, 0.81f, 0.81f, 0.0f).setOverlay(overlay).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
        consumer.addVertex(pose, 0.81f, 0.19f, 0.0f).setOverlay(overlay).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
        consumer.addVertex(pose, 0.19f, 0.19f, 0.0f).setOverlay(overlay).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
    }
}

