/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.client.renderers.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.client.models.HoverQuiltModel;
import dev.hyperlynx.reactive.entites.HoverQuilt;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class HoverQuiltRenderer
extends EntityRenderer<HoverQuilt>
implements RenderLayerParent<HoverQuilt, HoverQuiltModel> {
    public static final ResourceLocation TEXTURE_LOCATION = ReactiveMod.location("textures/entity/entity_quilt.png");
    private final HoverQuiltModel model;

    public HoverQuiltRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new HoverQuiltModel(context.bakeLayer(HoverQuiltModel.LAYER_LOCATION));
    }

    @NotNull
    public HoverQuiltModel getModel() {
        return this.model;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull HoverQuilt entity) {
        return TEXTURE_LOCATION;
    }

    public void render(@NotNull HoverQuilt quilt, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render((Entity)quilt, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        this.model.setupAnim(quilt, (float)quilt.animation_timer + partialTick);
        poseStack.pushPose();
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        poseStack.translate(0.0, -1.35, 0.0);
        this.model.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)TEXTURE_LOCATION)), packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }
}

