/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.client.renderers.rxn;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionEffects;
import dev.hyperlynx.reactive.alchemy.rxn.Reactor;
import dev.hyperlynx.reactive.client.particles.EnergyParticle;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.client.renderers.rxn.ReactionRenderer;
import dev.hyperlynx.reactive.integration.kubejs.ReactiveKubeJSPlugin;
import dev.hyperlynx.reactive.registration.ReactiveParticles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;

public class ReactionRenderers {
    public final Map<String, ReactionRenderer> RENDERERS = new HashMap<String, ReactionRenderer>();

    public ReactionRenderers() {
        this.RENDERERS.put("curse_assimilation", this::curseRing);
        this.RENDERERS.put("discharge_annihilation", this::annihilationSmoke);
        this.RENDERERS.put("smoke_annihilation", this::smoke);
        this.RENDERERS.put("growth", this::growth);
        this.RENDERERS.put("flames", this::flamethrower);
        this.RENDERERS.put("size_shrink_effect", this::acid_based);
        this.RENDERERS.put("size_grow_effect", this::verdant_based);
        this.RENDERERS.put("ominous_transformation", this::ominous);
        this.RENDERERS.put("astral_curse_annihilation", this::creation);
        this.RENDERERS.put("cryo", this::snow);
        this.RENDERERS.put("nodule", this::warpEnergy);
        this.RENDERERS.put("astral", this::astralRing);
    }

    public Iterable<ReactionRenderer> getRenderers(Iterable<String> aliases) {
        if (ModList.get().isLoaded("kubejs")) {
            ReactiveKubeJSPlugin.REACTION_EFFECT_CACHE.requestRenderers();
        }
        ArrayList<ReactionRenderer> ret = new ArrayList<ReactionRenderer>();
        for (String alias : aliases) {
            if (!this.RENDERERS.containsKey(alias)) continue;
            ret.add(this.RENDERERS.get(alias));
        }
        return ret;
    }

    public void smoke(Reactor reactor) {
        ParticleScribe.drawParticleReactionSurface(reactor.getLevel(), (ParticleOptions)ParticleTypes.LARGE_SMOKE, reactor, 0.3f);
    }

    public void annihilationSmoke(Reactor reactor) {
        ParticleScribe.drawParticleReactionSurface(reactor.getLevel(), (ParticleOptions)ParticleTypes.SMOKE, reactor, 0.2f);
    }

    public void curseRing(Reactor reactor) {
        RandomSource random = reactor.getLevel().random;
        if ((double)random.nextFloat() < 0.3) {
            Vec3 random_offset = new Vec3((double)random.nextFloat() * 0.4 - 0.2, (double)random.nextFloat() * 0.4 - 0.4, (double)random.nextFloat() * 0.4 - 0.2);
            ParticleScribe.drawExactParticleRing(reactor.getLevel(), (ParticleOptions)new EnergyParticle.Options(0.05f, ((Power)Powers.CURSE_POWER.get()).getColor(), reactor.getPos(), false, true), reactor.getPos().add(random_offset), 0.7, 1);
        }
    }

    public void astralRing(Reactor reactor) {
        RandomSource random = reactor.getLevel().random;
        if ((double)random.nextFloat() < 0.3) {
            Vec3 random_offset = new Vec3((double)random.nextFloat() * 0.4 - 0.2, (double)random.nextFloat() * 0.4 - 0.4, (double)random.nextFloat() * 0.4 - 0.2);
            ParticleScribe.drawExactParticleRing(reactor.getLevel(), (ParticleOptions)new EnergyParticle.Options(0.05f, ((Power)Powers.ASTRAL_POWER.get()).getColor(), reactor.getPos(), true, true), reactor.getPos().add(random_offset), 0.7, 1);
        }
    }

    public void growth(Reactor reactor) {
        ParticleScribe.drawParticleReactionSurface(reactor.getLevel(), (ParticleOptions)ParticleTypes.HAPPY_VILLAGER, reactor, 0.1f);
    }

    public void flamethrower(Reactor reactor) {
        if (reactor.getLevel() == null) {
            return;
        }
        if (reactor.getPowerLevel((Power)Powers.SOUL_POWER.get()) > 20) {
            ParticleScribe.drawParticleReactionSurface(reactor.getLevel(), (ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, reactor, 0.1f, 0.0, 0.1, 0.0);
        } else {
            ParticleScribe.drawParticleReactionSurface(reactor.getLevel(), (ParticleOptions)ParticleTypes.FLAME, reactor, 0.1f, 0.0, 0.1, 0.0);
        }
    }

    public void creation(Reactor reactor) {
        Set<BlockPos> points = ReactionEffects.getCreationPoints(reactor.getBlockPos());
        for (BlockPos pos : points) {
            if (!reactor.getLevel().getBlockState(pos).isAir()) continue;
            ParticleScribe.drawParticleSphere(Objects.requireNonNull(reactor.getLevel()), (ParticleOptions)ReactiveParticles.STARDUST, pos, 0.5, 1.0, 1);
        }
    }

    public void ominous(Reactor reactor) {
        ParticleScribe.drawParticleReactionSurface(reactor.getLevel(), (ParticleOptions)ParticleTypes.OMINOUS_SPAWNING, reactor, 0.005f);
    }

    public void acid_based(Reactor reactor) {
        Level level = reactor.getLevel();
        if (level.random.nextFloat() < 0.1f) {
            ParticleScribe.drawParticleReactionSurface(reactor.getLevel(), (ParticleOptions)ReactiveParticles.ACID_BUBBLE.getType(), reactor);
        }
    }

    public void verdant_based(Reactor reactor) {
        Level level = reactor.getLevel();
        if (level.random.nextFloat() < 0.1f) {
            ParticleScribe.drawParticleReactionSurface(level, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER, reactor);
        }
    }

    public void snow(Reactor reactor) {
        AABB aoe = new AABB(reactor.getBlockPos());
        aoe = aoe.inflate(5.0);
        ParticleScribe.drawParticleBox(reactor.getLevel(), (ParticleOptions)ParticleTypes.SNOWFLAKE, aoe, 1);
    }

    public void warpEnergy(Reactor reactor) {
        if (reactor.getLevel().random.nextFloat() < 0.2f) {
            ParticleScribe.drawParticleBox(reactor.getLevel(), (ParticleOptions)new EnergyParticle.Options(0.1f, ((Power)Powers.WARP_POWER.get()).getColor(), reactor.getPos(), true), AABB.ofSize((Vec3)reactor.getPos(), (double)1.0, (double)1.0, (double)1.0), 1);
        }
    }
}

