/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.entites;

import dev.hyperlynx.reactive.net.HoverQuiltHeightPayload;
import dev.hyperlynx.reactive.net.HoverQuiltVelocityPayload;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import java.util.Objects;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HoverQuilt
extends VehicleEntity {
    public final AnimationState hovering = new AnimationState();
    public long animation_timer = 0L;
    private boolean ridden_last_tick = false;
    private int position_force_timer = 0;
    private boolean client_position_lock = false;
    private static final double MAX_SPEED = 0.25;

    public HoverQuilt(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.hovering.start(0);
        this.setInvulnerable(false);
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean isPickable() {
        return true;
    }

    @NotNull
    protected Item getDropItem() {
        return (Item)ReactiveItems.PHANTOM_QUILT_ITEM.get();
    }

    @NotNull
    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        return HoverQuilt.getDefaultPassengerAttachmentPoint((Entity)this, (Entity)entity, (EntityAttachments)dimensions.attachments()).add(0.0, 0.05, 0.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof LivingEntity) {
            LivingEntity driver = (LivingEntity)entity;
            return driver;
        }
        return null;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            ++this.animation_timer;
            if (this.isVehicle() && this.isControlledByLocalInstance()) {
                LivingEntity riding_entity = this.getControllingPassenger();
                if (riding_entity instanceof LocalPlayer) {
                    LocalPlayer rider = (LocalPlayer)riding_entity;
                    float velocity = 0.0f;
                    if (rider.input.up || rider.input.jumping) {
                        velocity = 0.03f;
                    }
                    if (rider.input.down) {
                        velocity = -0.03f;
                    }
                    PacketDistributor.sendToServer((CustomPacketPayload)new HoverQuiltVelocityPayload(velocity), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                this.client_position_lock = false;
            } else {
                this.client_position_lock = !this.isVehicle();
            }
        } else if (!this.isVehicle()) {
            this.setDeltaMovement(0.0, 0.0, 0.0);
            if (this.ridden_last_tick) {
                this.position_force_timer = 10;
            }
            if (this.position_force_timer > 0) {
                PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new HoverQuiltHeightPayload(this.getId(), this.getY()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                --this.position_force_timer;
            }
            this.ridden_last_tick = false;
        } else {
            this.ridden_last_tick = true;
            Objects.requireNonNull(this.getControllingPassenger()).resetFallDistance();
        }
        if (this.isHittingRidersHead()) {
            this.setDeltaMovement(0.0, Math.min(-0.05, -this.getDeltaMovement().y), 0.0);
        } else if (this.isHittingRidersButt()) {
            this.setDeltaMovement(0.0, Math.max(0.05, -this.getDeltaMovement().y), 0.0);
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    private boolean isHittingRidersHead() {
        if (!this.isVehicle()) {
            return false;
        }
        LivingEntity passenger = this.getControllingPassenger();
        if (passenger == null) {
            return false;
        }
        AABB passenger_hitbox = passenger.getBoundingBox();
        double passenger_width = passenger_hitbox.getXsize();
        AABB passenger_top_box = new AABB(passenger_hitbox.getMaxPosition().subtract(passenger_width, 1.0, passenger_width), passenger_hitbox.getMaxPosition().add(0.0, 0.1, 0.0));
        return !this.level().noBlockCollision(null, passenger_top_box);
    }

    private boolean isHittingRidersButt() {
        if (!this.isVehicle()) {
            return false;
        }
        LivingEntity passenger = this.getControllingPassenger();
        if (passenger == null) {
            return false;
        }
        AABB passenger_hitbox = passenger.getBoundingBox();
        double passenger_width = passenger_hitbox.getXsize();
        AABB passenger_below_box = new AABB(passenger_hitbox.getMinPosition(), passenger_hitbox.getMinPosition().add(passenger_width, 1.0, passenger_width));
        return !this.level().noBlockCollision(null, passenger_below_box);
    }

    private double getMaxUpSpeed() {
        double current_height = this.position().y;
        double max_world_height = this.level().getMaxBuildHeight();
        if (current_height > max_world_height) {
            if (current_height - max_world_height > 10.0) {
                return 0.0;
            }
            return 0.25 * (1.0 / (current_height - max_world_height + 1.0));
        }
        return 0.25;
    }

    private double getMaxDownSpeed() {
        double current_height = this.position().y;
        double min_world_height = this.level().getMinBuildHeight();
        if (current_height < min_world_height) {
            if (current_height - min_world_height < -5.0) {
                return 0.0;
            }
            return -0.25 * (1.0 / (min_world_height - current_height + 1.0));
        }
        return -0.25;
    }

    public static void handleInputPacket(HoverQuiltVelocityPayload payload, IPayloadContext context) {
        Entity vehicle = context.player().getVehicle();
        if (vehicle instanceof HoverQuilt) {
            HoverQuilt quilt = (HoverQuilt)vehicle;
            quilt.setDeltaMovement(0.0, Math.clamp(payload.velocity() + quilt.getDeltaMovement().y, quilt.getMaxDownSpeed(), quilt.getMaxUpSpeed()), 0.0);
        }
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        InteractionResult super_interaction_result = super.interact(player, hand);
        if (super_interaction_result != InteractionResult.PASS) {
            return super_interaction_result;
        }
        if (player.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        if (!this.level().isClientSide) {
            return player.startRiding((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        return super.getDismountLocationForPassenger(passenger);
    }

    public static void handleHeightPacket(HoverQuiltHeightPayload payload, IPayloadContext context) {
        Entity vehicle = context.player().level().getEntity(payload.id());
        if (vehicle instanceof HoverQuilt) {
            HoverQuilt quilt = (HoverQuilt)vehicle;
            quilt.client_position_lock = false;
            quilt.setPos(quilt.getX(), payload.height(), quilt.getZ());
            quilt.client_position_lock = true;
            quilt.setDeltaMovement(0.0, 0.0, 0.0);
            quilt.setOldPosAndRot();
            quilt.lerpPositionAndRotationStep(1, quilt.getX(), payload.height(), quilt.getZ(), quilt.getYRot(), quilt.getXRot());
        }
    }

    public void setPos(double x, double y, double z) {
        if (this.client_position_lock) {
            return;
        }
        super.setPos(x, y, z);
    }
}

