/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.entites;

import com.mojang.datafixers.util.Either;
import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionStatusEntry;
import dev.hyperlynx.reactive.alchemy.rxn.Reactor;
import dev.hyperlynx.reactive.entites.data.ReactorData;
import dev.hyperlynx.reactive.net.ReactionStatusPayload;
import dev.hyperlynx.reactive.registration.ReactiveEntityDataSerializers;
import dev.hyperlynx.reactive.util.AreaMemory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ReactorEntity
extends Entity
implements Reactor {
    public static final int MAX_POWER = 10000;
    private static final EntityDataAccessor<ReactorData> SYNCED_REACTOR_DATA = SynchedEntityData.defineId(ReactorEntity.class, (EntityDataSerializer)((EntityDataSerializer)ReactiveEntityDataSerializers.REACTOR_DATA_SERIALIZER.get()));
    private static final EntityDataAccessor<Boolean> FORCE_GOLD_SYMBOL = SynchedEntityData.defineId(ReactorEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final String FORCE_GOLD_SYMBOL_KEY = "force_gold_symbol_key";
    private static final EntityDataAccessor<Boolean> USED_CRYSTAL = SynchedEntityData.defineId(ReactorEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final String USED_CRYSTAL_KEY = "has_used_crystal";
    private static final EntityDataAccessor<Integer> ELECTRIC_CHARGE = SynchedEntityData.defineId(ReactorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final String ELECTRIC_CHARGE_KEY = "charge";
    private static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.defineId(ReactorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final String LIFESPAN_KEY = "lifespan";
    private ReactorData server_reactor_data = new ReactorData(new HashMap<Power, Integer>(), new ArrayList<ReactionStatusEntry>());
    private static final String REACTOR_DATA_KEY = "reactor_data";
    private EndCrystal linked_crystal;
    private static final String LINKED_CRYSTAL_KEY = "crystal";
    private final List<String> render_aliases = new ArrayList<String>();
    private AreaMemory area_memory = null;
    private int sync_timer = 10;
    private int react_timer = 0;

    public ReactorEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = true;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            return;
        }
        if (this.sync_timer <= 0) {
            this.update();
            this.sync_timer = 10;
        } else {
            --this.sync_timer;
        }
        if (this.react_timer <= 0) {
            this.react((ServerLevel)this.level());
            this.react_timer = (Integer)ConfigMan.COMMON.crucibleTickDelay.get() * 5;
        } else {
            --this.react_timer;
        }
        if ((Integer)this.getEntityData().get(LIFESPAN) <= 0) {
            this.kill();
        }
        this.getEntityData().set(LIFESPAN, (Object)((Integer)this.getEntityData().get(LIFESPAN) - 1));
        this.tryMergeWithNeighbor();
    }

    private void tryMergeWithNeighbor() {
        List nearby_others = this.level().getEntitiesOfClass(ReactorEntity.class, this.getBoundingBox().inflate(4.0));
        nearby_others.remove(this);
        for (ReactorEntity neighbor : nearby_others) {
            Vec3 neighbor_pos = neighbor.getPos();
            Vec3 displacement = neighbor_pos.subtract(this.getPos());
            Vec3 step = displacement.normalize().multiply(0.015, 0.015, 0.015);
            this.move(MoverType.SELF, step);
        }
        List touching_others = this.level().getEntitiesOfClass(ReactorEntity.class, this.getBoundingBox());
        touching_others.remove(this);
        for (ReactorEntity touching : touching_others) {
            for (Power power : touching.getPowerMap().keySet()) {
                this.addPower(power, touching.getPowerLevel(power));
            }
            this.setLifespan(Math.max(touching.getLifespan(), this.getLifespan()));
            this.setElectricCharge(touching.getElectricCharge() + this.getElectricCharge());
            touching.kill();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SYNCED_REACTOR_DATA, (Object)new ReactorData(new HashMap<Power, Integer>(), new ArrayList<ReactionStatusEntry>()));
        builder.define(FORCE_GOLD_SYMBOL, (Object)false);
        builder.define(USED_CRYSTAL, (Object)false);
        builder.define(ELECTRIC_CHARGE, (Object)0);
        builder.define(LIFESPAN, (Object)6000);
    }

    public ReactorData reactorData() {
        if (this.level().isClientSide) {
            return (ReactorData)this.getEntityData().get(SYNCED_REACTOR_DATA);
        }
        return this.server_reactor_data;
    }

    private void update() {
        if (this.level().isClientSide) {
            throw new UnsupportedOperationException("Can't modify the state of the reaction data on the client!");
        }
        this.getEntityData().set(SYNCED_REACTOR_DATA, (Object)this.server_reactor_data.copy(), true);
    }

    private void update(ReactorData changed) {
        this.server_reactor_data = changed;
        this.update();
    }

    public void setLifespan(int lifespan) {
        this.getEntityData().set(LIFESPAN, (Object)lifespan);
    }

    public int getLifespan() {
        return (Integer)this.getEntityData().get(LIFESPAN);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        Level level;
        SynchedEntityData data = this.getEntityData();
        if (compound.contains(REACTOR_DATA_KEY)) {
            this.update(ReactorData.fromTag(compound.getCompound(REACTOR_DATA_KEY)));
        }
        if (compound.contains(FORCE_GOLD_SYMBOL_KEY)) {
            data.set(FORCE_GOLD_SYMBOL, (Object)compound.getBoolean(FORCE_GOLD_SYMBOL_KEY));
        }
        if (compound.contains(USED_CRYSTAL_KEY)) {
            data.set(USED_CRYSTAL, (Object)compound.getBoolean(USED_CRYSTAL_KEY));
        }
        if (compound.contains(ELECTRIC_CHARGE_KEY)) {
            data.set(ELECTRIC_CHARGE, (Object)compound.getInt(ELECTRIC_CHARGE_KEY));
        }
        if (compound.contains(LIFESPAN_KEY)) {
            data.set(LIFESPAN, (Object)compound.getInt(LIFESPAN_KEY));
        }
        if ((level = this.level()) instanceof ServerLevel) {
            UUID uuid;
            Entity entity;
            ServerLevel server = (ServerLevel)level;
            if (compound.contains(LINKED_CRYSTAL_KEY) && (entity = server.getEntity(uuid = compound.getUUID(LINKED_CRYSTAL_KEY))) instanceof EndCrystal) {
                EndCrystal crystal;
                this.linked_crystal = crystal = (EndCrystal)entity;
            }
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        SynchedEntityData data = this.getEntityData();
        compound.put(REACTOR_DATA_KEY, this.reactorData().toTag());
        compound.put(FORCE_GOLD_SYMBOL_KEY, (Tag)ByteTag.valueOf((boolean)((Boolean)data.get(FORCE_GOLD_SYMBOL))));
        compound.put(USED_CRYSTAL_KEY, (Tag)ByteTag.valueOf((boolean)((Boolean)data.get(USED_CRYSTAL))));
        compound.put(ELECTRIC_CHARGE_KEY, (Tag)IntTag.valueOf((int)((Integer)data.get(ELECTRIC_CHARGE))));
        compound.put(LIFESPAN_KEY, (Tag)IntTag.valueOf((int)((Integer)data.get(LIFESPAN))));
        if (this.linked_crystal != null) {
            compound.put(LINKED_CRYSTAL_KEY, (Tag)NbtUtils.createUUID((UUID)this.linked_crystal.getUUID()));
        }
    }

    @Override
    public boolean checkGoldSymbol() {
        return (Boolean)this.getEntityData().get(FORCE_GOLD_SYMBOL) != false || Reactor.super.checkGoldSymbol();
    }

    @Override
    public List<ReactionStatusEntry> getReactionStatus() {
        return this.reactorData().statuses();
    }

    @Override
    public void resetReactionStatus() {
        ReactorData data = this.reactorData();
        data.statuses().clear();
        this.update(data);
    }

    @Override
    public boolean hasUsedCrystalThisCycle() {
        return (Boolean)this.getEntityData().get(USED_CRYSTAL);
    }

    @Override
    public void setUsedCrystalThisCycle(boolean used) {
        this.getEntityData().set(USED_CRYSTAL, (Object)used);
    }

    @Override
    public BlockState getBlockState() {
        return this.level().getBlockState(this.getBlockPos());
    }

    @Override
    public BlockPos getBlockPos() {
        return this.blockPosition();
    }

    @Override
    public Vec3 getPos() {
        return this.position();
    }

    @Override
    public void setDirty() {
    }

    @Override
    public int maxPower() {
        return 10000;
    }

    @Override
    @NotNull
    public Map<Power, Integer> getPowerMap() {
        return this.reactorData().powers();
    }

    @Override
    public AreaMemory getAreaMemory() {
        if (this.area_memory == null) {
            this.area_memory = new AreaMemory(this.getBlockPos());
        }
        return this.area_memory;
    }

    @Override
    public Level getLevel() {
        return this.level();
    }

    @Override
    public int getElectricCharge() {
        return (Integer)this.getEntityData().get(ELECTRIC_CHARGE);
    }

    @Override
    public void setElectricCharge(int i) {
        this.getEntityData().set(ELECTRIC_CHARGE, (Object)i);
    }

    @Override
    public void clearRenderReactions() {
        this.render_aliases.clear();
    }

    @Override
    public void addRenderReaction(String s) {
        this.render_aliases.add(s);
    }

    @Override
    public Iterable<String> getRenderReactions() {
        return this.render_aliases;
    }

    @Override
    public EndCrystal getLinkedCrystal() {
        return this.linked_crystal;
    }

    @Override
    public void setLinkedCrystal(EndCrystal end_crystal) {
        this.linked_crystal = end_crystal;
    }

    @Override
    public void unlinkCrystal(Level level, BlockPos pos, BlockState state) {
        this.linked_crystal.setBeamTarget(null);
        this.linked_crystal = null;
    }

    public void setPowers(@NotNull Map<Power, Integer> power_map_to_copy) {
        this.server_reactor_data.powers().clear();
        for (Power power : power_map_to_copy.keySet()) {
            this.server_reactor_data.powers().put(power, power_map_to_copy.get(power));
        }
    }

    @Override
    public ReactionStatusPayload getPayload() {
        return new ReactionStatusPayload(new ArrayList<ReactionStatusEntry>(this.getReactionStatus()), new ReactionStatusPayload.Target((Either<BlockPos, Integer>)Either.right((Object)this.getId())));
    }
}

