/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.iris;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.hyperlynx.reactive.be.GatewayBlockEntity;
import dev.hyperlynx.reactive.client.renderers.be.GatewayRenderer;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.uniforms.SystemTimeUniforms;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.TheEndPortalRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class IrisGatewayRenderer
extends GatewayRenderer<GatewayBlockEntity>
implements BlockEntityRenderer<GatewayBlockEntity> {
    private static final float RED = 0.075f;
    private static final float GREEN = 0.15f;
    private static final float BLUE = 0.2f;

    public IrisGatewayRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    private boolean isNotUsingShaders() {
        return Iris.getCurrentPack().isEmpty();
    }

    @Override
    public void render(GatewayBlockEntity gateway, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int overlay) {
        if (this.isNotUsingShaders()) {
            super.render(gateway, partialTick, poseStack, multiBufferSource, light, overlay);
            return;
        }
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)TheEndPortalRenderer.END_PORTAL_LOCATION));
        PoseStack.Pose pose = poseStack.last();
        float progress = SystemTimeUniforms.TIMER.getFrameTimeCounter() * 0.01f % 1.0f;
        this.renderVolume(gateway, new IrisGatewayRendererContext(vertexConsumer, pose, progress, light, overlay), partialTick);
    }

    @Override
    protected void renderFace(GatewayRenderer.GatewayRenderContext context, float x0, float x1, float y0, float y1, float z0, float z1, float z2, float z3, float ul_distort, float dl_distort, float ur_distort, float dr_distort) {
        if (context instanceof IrisGatewayRendererContext) {
            IrisGatewayRendererContext iris_context = (IrisGatewayRendererContext)context;
            iris_context.calculateNormal(new Vector3f(x0, y0, z0), new Vector3f(x1, y0, z1), new Vector3f(x1, y1, z2));
        }
        super.renderFace(context, x0, x1, y0, y1, z0, z1, z2, z3, ul_distort, dl_distort, ur_distort, dr_distort);
    }

    public static class IrisGatewayRendererContext
    extends GatewayRenderer.GatewayRenderContext {
        final int light;
        final int overlay;
        final float progress;
        int count;
        Vector3f normal;

        protected IrisGatewayRendererContext(VertexConsumer consumer, PoseStack.Pose pose, float progress, int light, int overlay) {
            super(consumer, pose);
            this.light = light;
            this.progress = progress;
            this.overlay = overlay;
            this.count = 0;
        }

        protected void calculateNormal(Vector3f a, Vector3f b, Vector3f c) {
            Vector3f u = b.sub((Vector3fc)a);
            Vector3f v = c.sub((Vector3fc)a);
            float x = u.y * v.z - u.z * v.y;
            float y = u.z * v.x - u.x * v.z;
            float z = u.x * v.y - u.y * v.x;
            this.normal = new Vector3f(x, y, z);
        }

        @Override
        protected void renderVertex(float x, float y, float z) {
            float v_offset = this.count < 2 ? 0.2f : 0.0f;
            float v1_offset = this.count % 2 == 0 ? 0.0f : 0.2f;
            this.consumer.addVertex(this.pose, x, y, z).setColor(0.075f, 0.15f, 0.2f, 1.0f).setLight(this.light).setOverlay(this.overlay).setUv(v_offset + this.progress, v1_offset + this.progress).setNormal(this.pose, this.normal.x, this.normal.y, this.normal.z);
            this.count = (this.count + 1) % 4;
        }
    }
}

