/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.jei;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.integration.jei.ReactiveJEIPlugin;
import dev.hyperlynx.reactive.integration.jei.SlotManager;
import dev.hyperlynx.reactive.recipes.DissolveRecipe;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import dev.hyperlynx.reactive.registration.ReactiveRecipes;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DissolveRecipeCategory
implements IRecipeCategory<RecipeHolder<DissolveRecipe>> {
    final SlotManager slot_manager = new SlotManager();

    public DissolveRecipeCategory() {
        this.slot_manager.addSlot("reactant", 1, 1);
        this.slot_manager.addSlot("product", 55, 1);
        this.slot_manager.addSlot("power_result", 55, 22);
    }

    @Nullable
    public ResourceLocation getRegistryName(@Nullable RecipeHolder<DissolveRecipe> holder) {
        assert (holder != null);
        return holder.id();
    }

    @NotNull
    public RecipeType<RecipeHolder<DissolveRecipe>> getRecipeType() {
        return RecipeType.createFromVanilla((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ReactiveRecipes.DISSOLVE_RECIPE_TYPE.get()));
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"title.reactive.dissolve");
    }

    public IDrawable background() {
        return ReactiveJEIPlugin.HELPERS.getGuiHelper().createDrawable(ReactiveMod.location("textures/gui/tf_jei.png"), 2, 2, 72, 39);
    }

    public int getHeight() {
        return this.background().getHeight();
    }

    public int getWidth() {
        return this.background().getWidth();
    }

    public IDrawable getIcon() {
        return ReactiveJEIPlugin.HELPERS.getGuiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((BlockItem)ReactiveItems.CRUCIBLE.get()).getDefaultInstance());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<DissolveRecipe> holder, @NotNull IFocusGroup focuses) {
        DissolveRecipe recipe = (DissolveRecipe)holder.value();
        IRecipeSlotBuilder input_slot = this.slot_manager.buildSlot(builder, "reactant", RecipeIngredientRole.INPUT);
        IRecipeSlotBuilder output_slot = this.slot_manager.buildSlot(builder, "product", RecipeIngredientRole.OUTPUT);
        input_slot.addItemStacks(List.of(recipe.getReactant().getItems()));
        output_slot.addItemStack(recipe.getProduct());
        if (((Boolean)ConfigMan.CLIENT.showPowerSources.get()).booleanValue()) {
            IRecipeSlotBuilder power_slot = this.slot_manager.buildSlot(builder, "power_result", RecipeIngredientRole.OUTPUT);
            for (ItemStack input : recipe.getReactant().getItems()) {
                power_slot.addIngredients((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, Power.getSourcePower(input));
            }
        }
    }

    public void draw(RecipeHolder<DissolveRecipe> holder, @Nullable IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics gui, double mouseX, double mouseY) {
        this.background().draw(gui);
        if (((DissolveRecipe)holder.value()).needs_electricity) {
            this.drawElectricLabel(gui);
        }
        this.slot_manager.drawSlotBackgrounds(gui, List.of("reactant", "product"));
        if (((Boolean)ConfigMan.CLIENT.showPowerSources.get()).booleanValue()) {
            this.slot_manager.drawSlotBackground(gui, "power_result");
        }
    }

    private void drawElectricLabel(GuiGraphics gui) {
        Minecraft minecraft = Minecraft.getInstance();
        int width = minecraft.font.width("Charge");
        int center = this.getWidth() / 2;
        int x = center - width / 2;
        int y = 11;
        gui.drawString(minecraft.font, "Charge", x, y, 895144);
    }
}

