/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.jei;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.integration.jei.ReactiveJEIPlugin;
import dev.hyperlynx.reactive.integration.jei.SlotManager;
import dev.hyperlynx.reactive.recipes.TransmuteRecipe;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import dev.hyperlynx.reactive.registration.ReactiveRecipes;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransmuteRecipeCategory
implements IRecipeCategory<RecipeHolder<TransmuteRecipe>> {
    final SlotManager slot_manager = new SlotManager();

    public TransmuteRecipeCategory() {
        this.slot_manager.addSlot("reactant", 1, 1);
        this.slot_manager.addSlot("product", 55, 1);
        this.slot_manager.addSlot("center_reagent", 28, 22);
        this.slot_manager.addSlot("mid_left_reagent", 19, 22);
        this.slot_manager.addSlot("mid_right_reagent", 37, 22);
        this.slot_manager.addSlot("left_reagent", 10, 22);
        this.slot_manager.addSlot("right_reagent", 46, 22);
    }

    @Nullable
    public ResourceLocation getRegistryName(@Nullable RecipeHolder<TransmuteRecipe> holder) {
        if (holder == null) {
            return null;
        }
        return holder.id();
    }

    public RecipeType<RecipeHolder<TransmuteRecipe>> getRecipeType() {
        return RecipeType.createFromVanilla((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ReactiveRecipes.TRANS_RECIPE_TYPE.get()));
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"title.reactive.transmute");
    }

    public IDrawable background() {
        return ReactiveJEIPlugin.HELPERS.getGuiHelper().createDrawable(ReactiveMod.location("textures/gui/tf_jei.png"), 2, 2, 72, 39);
    }

    public int getWidth() {
        return this.background().getWidth();
    }

    public int getHeight() {
        return this.background().getHeight();
    }

    public IDrawable getIcon() {
        return ReactiveJEIPlugin.HELPERS.getGuiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((BlockItem)ReactiveItems.CRUCIBLE.get()).getDefaultInstance());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<TransmuteRecipe> holder, @Nullable IFocusGroup focuses) {
        TransmuteRecipe recipe = (TransmuteRecipe)holder.value();
        IRecipeSlotBuilder input_slot = this.slot_manager.buildSlot(builder, "reactant", RecipeIngredientRole.INPUT);
        input_slot.addItemStacks(List.of(recipe.getReactant().getItems()));
        IRecipeSlotBuilder output_slot = this.slot_manager.buildSlot(builder, "product", RecipeIngredientRole.OUTPUT);
        assert (Minecraft.getInstance().level != null);
        output_slot.addItemStack(recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
        switch (recipe.getReagents().size()) {
            case 1: {
                IRecipeSlotBuilder power_slot = this.slot_manager.buildSlot(builder, "center_reagent", RecipeIngredientRole.CATALYST);
                power_slot.addIngredient((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, (Object)recipe.getReagents().getFirst());
                break;
            }
            case 2: {
                IRecipeSlotBuilder power_slotl = this.slot_manager.buildSlot(builder, "mid_left_reagent", RecipeIngredientRole.CATALYST);
                power_slotl.addIngredient((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, (Object)recipe.getReagents().getFirst());
                IRecipeSlotBuilder power_slotr = this.slot_manager.buildSlot(builder, "mid_right_reagent", RecipeIngredientRole.CATALYST);
                power_slotr.addIngredient((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, (Object)recipe.getReagents().get(1));
                break;
            }
            case 3: {
                IRecipeSlotBuilder power_slotl = this.slot_manager.buildSlot(builder, "left_reagent", RecipeIngredientRole.CATALYST);
                power_slotl.addIngredient((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, (Object)recipe.getReagents().getFirst());
                IRecipeSlotBuilder power_slot = this.slot_manager.buildSlot(builder, "center_reagent", RecipeIngredientRole.CATALYST);
                power_slot.addIngredient((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, (Object)recipe.getReagents().get(1));
                IRecipeSlotBuilder power_slotr = this.slot_manager.buildSlot(builder, "right_reagent", RecipeIngredientRole.CATALYST);
                power_slotr.addIngredient((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, (Object)recipe.getReagents().get(2));
                break;
            }
            default: {
                IRecipeSlotBuilder power_slot = this.slot_manager.buildSlot(builder, "center_reagent", RecipeIngredientRole.CATALYST);
                power_slot.addIngredients((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, recipe.getReagents());
            }
        }
    }

    public void draw(RecipeHolder<TransmuteRecipe> holder, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics gui, double mouseX, double mouseY) {
        this.background().draw(gui);
        if (((TransmuteRecipe)holder.value()).needs_electricity) {
            this.drawElectricLabel(gui);
        }
        this.slot_manager.drawSlotBackgrounds(gui, List.of("reactant", "product"));
        switch (((TransmuteRecipe)holder.value()).getReagents().size()) {
            case 2: {
                this.slot_manager.drawSlotBackgrounds(gui, List.of("mid_left_reagent", "mid_right_reagent"));
                break;
            }
            case 3: {
                this.slot_manager.drawSlotBackgrounds(gui, List.of("left_reagent", "center_reagent", "right_reagent"));
                break;
            }
            default: {
                this.slot_manager.drawSlotBackground(gui, "center_reagent");
            }
        }
    }

    private void drawElectricLabel(GuiGraphics gui) {
        Minecraft minecraft = Minecraft.getInstance();
        int width = minecraft.font.width("Charge");
        int center = this.getWidth() / 2;
        int x = center - width / 2;
        int y = 11;
        gui.drawString(minecraft.font, "Charge", x, y, 895144);
    }
}

