/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.jei.bottles;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.integration.jei.bottles.PowerBottleRecipe;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class PowerBottleRecipeSerializer
implements RecipeSerializer<PowerBottleRecipe> {
    public static final MapCodec<PowerBottleRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"power_bottle").forGetter(Recipe::getGroup), (App)((Registry)Powers.POWERS.getRegistry().get()).byNameCodec().fieldOf("power").forGetter(PowerBottleRecipe::getPower)).apply((Applicative)instance, PowerBottleRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PowerBottleRecipe> STREAM_CODEC = StreamCodec.of(PowerBottleRecipeSerializer::toNetwork, PowerBottleRecipeSerializer::fromNetwork);

    @NotNull
    public static PowerBottleRecipe fromNetwork(@NotNull RegistryFriendlyByteBuf buffer) {
        Power power = (Power)Powers.POWER_REGISTRY.get(buffer.readResourceKey(Powers.POWER_REGISTRY_KEY));
        return new PowerBottleRecipe("power_bottle", Objects.requireNonNullElseGet(power, () -> new Power("error", 0xFF0000, Blocks.WATER, null)));
    }

    public static void toNetwork(@NotNull RegistryFriendlyByteBuf buffer, @NotNull PowerBottleRecipe recipe) {
        buffer.writeResourceKey((ResourceKey)Powers.POWER_REGISTRY.getResourceKey((Object)recipe.power).orElseThrow());
    }

    public MapCodec<PowerBottleRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, PowerBottleRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

