/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.kubejs;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.alchemy.rxn.Reactor;
import dev.hyperlynx.reactive.client.renderers.rxn.ReactionRenderer;
import dev.hyperlynx.reactive.integration.kubejs.ReactiveKubeJSPlugin;
import dev.hyperlynx.reactive.integration.kubejs.events.CustomReactionTickEvent;
import dev.hyperlynx.reactive.integration.kubejs.events.EventTransceiver;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.event.KubeEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class CustomReaction
extends Reaction {
    protected int cost = 0;
    protected int yield = 0;
    protected Optional<Power> output_power = Optional.empty();
    public static final StreamCodec<RegistryFriendlyByteBuf, CustomReaction> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, Reaction::getAlias, (StreamCodec)ByteBufCodecs.map(HashMap::new, Power.STREAM_CODEC, (StreamCodec)ByteBufCodecs.INT), Reaction::getReagents, (StreamCodec)ByteBufCodecs.INT, CustomReaction::cost, (StreamCodec)ByteBufCodecs.INT, CustomReaction::yield, (StreamCodec)Power.STREAM_CODEC.apply(ByteBufCodecs::optional), CustomReaction::outputPower, (StreamCodec)StreamCodec.of(CustomReaction::serializeName, CustomReaction::deserializeName), Reaction::getName, CustomReaction::new);

    protected static void serializeName(RegistryFriendlyByteBuf buffer, MutableComponent name) {
        if (name == null) {
            ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8).encode((Object)buffer, Optional.empty());
            return;
        }
        ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8).encode((Object)buffer, Optional.of(Component.Serializer.toJson((Component)name, (HolderLookup.Provider)buffer.registryAccess())));
    }

    protected static MutableComponent deserializeName(RegistryFriendlyByteBuf buffer) {
        Optional json = (Optional)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8).decode((Object)buffer);
        return json.map(s -> Component.Serializer.fromJson((String)s, (HolderLookup.Provider)buffer.registryAccess())).orElse(null);
    }

    public CustomReaction(String alias, List<Power> required_powers, MutableComponent name_override) {
        super(alias, 0);
        for (Power required_power : required_powers) {
            this.reagents.put(required_power, WorldSpecificValue.get(alias + String.valueOf(required_power) + "required", 1, 400));
        }
        this.name = name_override;
    }

    private CustomReaction(String alias, Map<Power, Integer> reagents, int cost, int yield, Optional<Power> output, MutableComponent name) {
        super(alias);
        this.reagents = reagents;
        this.cost = cost;
        this.yield = yield;
        this.output_power = output;
        this.name = name;
    }

    protected int cost() {
        return this.cost;
    }

    protected int yield() {
        return this.yield;
    }

    protected Optional<Power> outputPower() {
        return this.output_power;
    }

    @Override
    public Reaction.Status conditionsMet(Reactor crucible) {
        Reaction.Status status = super.conditionsMet(crucible);
        if (!status.equals((Object)Reaction.Status.REACTING)) {
            return status;
        }
        CustomReactionTickEvent event = new CustomReactionTickEvent(this, crucible);
        EventResult result = ReactiveKubeJSPlugin.REACTION_EFFECT_CACHE.processServerTestEvent(event);
        if (result.interruptFalse()) {
            return Reaction.Status.INHIBITED;
        }
        return status;
    }

    @Override
    public void run(Reactor reactor) {
        ReactiveKubeJSPlugin.REACTION_EFFECT_CACHE.processRunEvent(new CustomReactionTickEvent(this, reactor));
        if (this.cost > 0) {
            this.expendPower(reactor, this.cost);
        }
        this.output_power.ifPresent(power -> reactor.addPower((Power)power, this.yield));
        super.run(reactor);
    }

    public static ReactionRenderer getRenderFunction(String alias) {
        return reactor -> EventTransceiver.CUSTOM_REACTION_RENDER_EVENT.post((KubeEvent)new CustomReactionTickEvent(alias, reactor));
    }

    private void expendPower(Reactor reactor, int cost) {
        for (Power p : this.getReagents().keySet()) {
            reactor.expendPower(p, (int)((double)cost / (double)this.getReagents().size()) + 1);
            reactor.setDirty();
        }
    }
}

