/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.kubejs;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionMan;
import dev.hyperlynx.reactive.integration.kubejs.CustomReaction;
import dev.hyperlynx.reactive.integration.kubejs.KubeScriptException;
import dev.hyperlynx.reactive.integration.kubejs.ReactiveKubeJSPlugin;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class ReactionFactory {
    CustomReaction rxn;

    public ReactionFactory(Level level, String alias, MutableComponent custom_name, List<Power> reagent_locations) {
        if (ReactiveMod.REACTION_MAN.get(level, alias) != null) {
            throw new KubeScriptException("Reaction aliases '" + alias + "' already exists! Ignoring this registration attempt...");
        }
        this.rxn = new CustomReaction(alias, reagent_locations, custom_name);
        ReactiveKubeJSPlugin.CUSTOM_REACTION_ALIASES.add(this.rxn.getAlias());
    }

    private void warnOverwrites() {
        if (!this.rxn.getStimulus().equals((Object)Reaction.Stimulus.NONE)) {
            System.out.println("Overwriting the previous Reaction Stimulus for " + this.rxn.getAlias());
        }
    }

    public ReactionFactory needsGoldSymbol() {
        this.warnOverwrites();
        this.rxn.setStimulus(Reaction.Stimulus.GOLD_SYMBOL);
        return this;
    }

    public ReactionFactory needsElectric() {
        this.warnOverwrites();
        this.rxn.setStimulus(Reaction.Stimulus.ELECTRIC);
        return this;
    }

    public ReactionFactory needsNoElectric() {
        this.warnOverwrites();
        this.rxn.setStimulus(Reaction.Stimulus.NO_ELECTRIC);
        return this;
    }

    public ReactionFactory needsEndCrystal() {
        this.warnOverwrites();
        this.rxn.setStimulus(Reaction.Stimulus.END_CRYSTAL);
        return this;
    }

    public ReactionFactory needsNoEndCrystal() {
        this.warnOverwrites();
        this.rxn.setStimulus(Reaction.Stimulus.NO_END_CRYSTAL);
        return this;
    }

    public ReactionFactory setCost(int cost) {
        if (cost < 0) {
            throw new KubeScriptException("Cost cannot be negative! Try using a yield instead.");
        }
        this.rxn.cost = cost;
        return this;
    }

    public ReactionFactory setYield(String power_id, int yield) {
        if (yield < 0) {
            throw new KubeScriptException("Yield cannot be negative!");
        }
        Power p = (Power)Powers.POWER_REGISTRY.get(ResourceLocation.parse((String)power_id));
        if (p != null) {
            this.rxn.yield = yield;
            this.rxn.output_power = Optional.of(p);
        }
        return this;
    }

    public ReactionFactory alwaysPerfect() {
        this.rxn.markAlwaysPerfect();
        return this;
    }

    public void build() {
        ReactionMan.addReactions(this.rxn);
    }
}

