/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.kubejs.events;

import dev.hyperlynx.reactive.integration.kubejs.ReactiveKubeJSPlugin;
import dev.hyperlynx.reactive.integration.kubejs.events.CustomReactionTickEvent;
import dev.hyperlynx.reactive.integration.kubejs.events.EventTransceiver;
import dev.latvian.mods.kubejs.event.EventExit;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.event.IEventHandler;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.rhino.WrappedException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;

public class EventHandlerCache {
    private final List<IEventHandler> reaction_runners = new ArrayList<IEventHandler>();
    private final List<IEventHandler> server_reaction_tests = new ArrayList<IEventHandler>();
    public boolean received_renderers = false;
    private Instant last_request_timestamp;

    public void ingestReactionHandlers() {
        EventTransceiver.CUSTOM_REACTION_RUN_EVENT.forEachListener(ScriptType.SERVER, container -> this.reaction_runners.add(container.handler));
        EventTransceiver.CUSTOM_REACTION_TEST_CONDITIONS_EVENT.forEachListener(ScriptType.SERVER, container -> this.server_reaction_tests.add(container.handler));
    }

    public void resetReactionHandlers() {
        this.reaction_runners.clear();
        this.server_reaction_tests.clear();
    }

    private EventResult processEvent(KubeEvent event, List<IEventHandler> handlers) {
        Iterator<IEventHandler> iterator = handlers.iterator();
        if (iterator.hasNext()) {
            IEventHandler handler = iterator.next();
            try {
                handler.onEvent(event);
                return EventResult.PASS;
            }
            catch (EventExit exit) {
                return exit.result;
            }
            catch (WrappedException exception) {
                Throwable throwable = exception.getWrappedException();
                if (throwable instanceof EventExit) {
                    EventExit exit = (EventExit)throwable;
                    return exit.result;
                }
                throw exception;
            }
        }
        return EventResult.PASS;
    }

    public EventResult processServerTestEvent(CustomReactionTickEvent event) {
        return this.processEvent(event, this.server_reaction_tests);
    }

    public EventResult processRunEvent(CustomReactionTickEvent event) {
        return this.processEvent(event, this.reaction_runners);
    }

    public void requestRenderers() {
        if (this.received_renderers) {
            return;
        }
        if (this.last_request_timestamp == null || this.last_request_timestamp.isBefore(Instant.now().minus(10L, ChronoUnit.SECONDS))) {
            ReactiveKubeJSPlugin.LOGGER.info("Requesting KubeJS reaction aliases");
            PacketDistributor.sendToServer((CustomPacketPayload)new ReactiveKubeJSPlugin.ReactionAliasRequestPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.last_request_timestamp = Instant.now();
        }
    }
}

