/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.kubejs.events;

import dev.hyperlynx.reactive.alchemy.rxn.ReactionMan;
import dev.hyperlynx.reactive.alchemy.special.DissolveEvent;
import dev.hyperlynx.reactive.alchemy.special.EmptyEvent;
import dev.hyperlynx.reactive.integration.kubejs.ReactiveKubeJSPlugin;
import dev.hyperlynx.reactive.integration.kubejs.events.CustomReactionTickEvent;
import dev.hyperlynx.reactive.integration.kubejs.events.KubeDissolveEvent;
import dev.hyperlynx.reactive.integration.kubejs.events.KubeEmptyEvent;
import dev.hyperlynx.reactive.integration.kubejs.events.KubeReactionConstructEvent;
import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import net.neoforged.bus.api.SubscribeEvent;

public class EventTransceiver {
    public static final EventGroup EVENTS = EventGroup.of((String)"ReactiveEvents");
    public static final EventHandler CRUCIBLE_DISSOLVE_EVENT = EVENTS.common("dissolveItem", () -> KubeDissolveEvent.class);
    public static final EventHandler CRUCIBLE_EMPTY_EVENT = EVENTS.common("emptyCrucible", () -> KubeEmptyEvent.class);
    public static final EventHandler REACTION_BUILD_EVENT = EVENTS.common("constructReactions", () -> KubeReactionConstructEvent.class);
    public static final EventHandler CUSTOM_REACTION_TEST_CONDITIONS_EVENT = EVENTS.common("checkReaction", () -> CustomReactionTickEvent.class).hasResult();
    public static final EventHandler CUSTOM_REACTION_RUN_EVENT = EVENTS.server("runReaction", () -> CustomReactionTickEvent.class);
    public static final EventHandler CUSTOM_REACTION_RENDER_EVENT = EVENTS.client("renderReaction", () -> CustomReactionTickEvent.class);

    @SubscribeEvent
    private static void translateDissolveEvent(DissolveEvent event) {
        CRUCIBLE_DISSOLVE_EVENT.post((ScriptTypeHolder)ScriptType.SERVER, (KubeEvent)new KubeDissolveEvent(event));
    }

    @SubscribeEvent
    private static void translateEmptyEvent(EmptyEvent event) {
        CRUCIBLE_EMPTY_EVENT.post((ScriptTypeHolder)ScriptType.SERVER, (KubeEvent)new KubeEmptyEvent(event));
    }

    @SubscribeEvent
    private static void translateConstructReactionEvent(ReactionMan.ReactionConstructEvent event) {
        if (!event.level.isClientSide()) {
            ReactiveKubeJSPlugin.CUSTOM_REACTION_ALIASES.clear();
            REACTION_BUILD_EVENT.post((ScriptTypeHolder)ScriptType.SERVER, (KubeEvent)new KubeReactionConstructEvent(event));
        }
    }

    @SubscribeEvent
    private static void translateReactionResetEvent(ReactionMan.ReactionResetEvent event) {
        ReactiveKubeJSPlugin.REACTION_EFFECT_CACHE.resetReactionHandlers();
        ReactiveKubeJSPlugin.REACTION_EFFECT_CACHE.ingestReactionHandlers();
    }
}

