/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.patchouli;

import dev.hyperlynx.reactive.recipes.DissolveRecipe;
import dev.hyperlynx.reactive.registration.ReactiveRecipes;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class DissolveComponentProcessor
implements IComponentProcessor {
    private DissolveRecipe recipe;

    public void setup(Level level, IVariableProvider variables) {
        String reactant = variables.get("reactant", (HolderLookup.Provider)level.registryAccess()).asString();
        List recipes = level.getRecipeManager().getAllRecipesFor((RecipeType)ReactiveRecipes.DISSOLVE_RECIPE_TYPE.get());
        for (RecipeHolder r : recipes) {
            for (ItemStack i : ((DissolveRecipe)r.value()).getReactant().getItems()) {
                if (!i.getItem().equals(BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)reactant)))) continue;
                this.recipe = (DissolveRecipe)r.value();
            }
        }
    }

    @Nullable
    public IVariable process(Level level, @NotNull String key) {
        if (this.recipe == null) {
            return IVariable.empty();
        }
        if (key.equals("product")) {
            return IVariable.from((Object)this.recipe.getResultItem((HolderLookup.Provider)level.registryAccess()), (HolderLookup.Provider)level.registryAccess());
        }
        return null;
    }
}

