/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.patchouli;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.material.FlagMaterialProperty;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperty;
import dev.hyperlynx.reactive.alchemy.material.formula.PropertyFormulaRequirements;
import dev.hyperlynx.reactive.registration.ReactiveDataMaps;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class MaterialPropertyComponentProcessor
implements IComponentProcessor {
    ResourceLocation property_id = ReactiveMod.location("error");

    public void setup(Level level, IVariableProvider variables) {
        this.property_id = ResourceLocation.parse((String)variables.get("property", (HolderLookup.Provider)level.registryAccess()).asString());
    }

    @Nullable
    public IVariable process(Level level, String key) {
        if (key.equals("formula")) {
            Holder.Reference<MaterialProperty<?>> property = this.property();
            PropertyFormulaRequirements data = (PropertyFormulaRequirements)property.getData(ReactiveDataMaps.PROPERTY_FORMULA_MAP);
            if (data == null) {
                ReactiveMod.LOGGER.error("Couldn't load formula data maps in level {}", (Object)level);
                return IVariable.wrap((String)"$(4)No formula data map could be loaded.", (HolderLookup.Provider)level.registryAccess());
            }
            List<PropertyFormulaRequirements.Part> requirements = data.requirements();
            StringBuilder formula = new StringBuilder();
            if (!requirements.isEmpty()) {
                formula.append(Component.translatable((String)"docs.reactive.formula_label").getString());
                requirements.forEach(requirement -> {
                    formula.append(Component.translatable((String)"docs.reactive.at_least").getString());
                    int percent = requirement.lowBound(this.property_id) / 16;
                    formula.append((String)(percent >= 1 ? percent + "% " : Component.translatable((String)"docs.reactive.trace").getString()));
                    formula.append(Component.translatable((String)requirement.power_id().toLanguageKey("power")).getString());
                    formula.append("$(br)");
                });
                formula.append("$(br)");
            }
            if (!(property.value() instanceof FlagMaterialProperty)) {
                List outcomes = Objects.requireNonNull((List)property.getData(ReactiveDataMaps.FORMULA_OUTCOME_MAP));
                formula.append(Component.translatable((String)"docs.reactive.outcome_label").getString());
                outcomes.forEach(outcome -> {
                    ResourceLocation power_id = outcome.power();
                    if (power_id != null) {
                        formula.append(Component.translatable((String)power_id.toLanguageKey("power")).getString());
                        formula.append("$(br)");
                    }
                });
            }
            return IVariable.wrap((String)formula.toString(), (HolderLookup.Provider)level.registryAccess());
        }
        return null;
    }

    private Holder.Reference<MaterialProperty<?>> property() {
        Optional property = MaterialProperties.PROPERTY_REGISTRY.getHolder(this.property_id);
        if (property.isEmpty()) {
            throw new NoSuchElementException("No material property with id " + String.valueOf(this.property_id));
        }
        return (Holder.Reference)property.get();
    }
}

