/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.PowerBottleInsertContext;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.WorldSpecificValues;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.blocks.CrucibleBlock;
import dev.hyperlynx.reactive.items.QuartzBottleItem;
import dev.hyperlynx.reactive.items.WarpBottleItem;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;

public interface BasePowerBottle {
    public static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack dispense(BlockSource source, ItemStack stack) {
            BlockPos target = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
            if (!(source.level().getBlockState(target).getBlock() instanceof CrucibleBlock)) {
                return this.defaultDispenseItemBehavior.dispense(source, stack);
            }
            CrucibleBlockEntity crucible = (CrucibleBlockEntity)source.level().getBlockEntity(target);
            if (crucible == null) {
                return this.defaultDispenseItemBehavior.dispense(source, stack);
            }
            boolean changed = false;
            for (Power p : (Registry)Powers.POWERS.getRegistry().get()) {
                if (!p.matchesBottle(stack) || !crucible.addPower(p, WorldSpecificValues.BOTTLE_RETURN.get())) continue;
                if (stack.is((Item)ReactiveItems.WARP_BOTTLE.get()) && WarpBottleItem.isRiftBottle(stack)) {
                    crucible.enderRiftStrength = 2000;
                }
                stack.shrink(1);
                ItemEntity quartz_bottle_drop = new ItemEntity((Level)source.level(), (double)target.getX() + 0.5, (double)target.getY() + 0.6, (double)target.getZ() + 0.5, ((QuartzBottleItem)((Object)ReactiveItems.QUARTZ_BOTTLE.get())).getDefaultInstance());
                source.level().addFreshEntity((Entity)quartz_bottle_drop);
                changed = true;
            }
            if (changed) {
                crucible.setDirty();
                if (crucible.getLevel() != null) {
                    crucible.getLevel().playSound(null, crucible.getBlockPos(), SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 0.65f + crucible.getLevel().getRandom().nextFloat() / 5.0f);
                }
            }
            return stack;
        }
    };

    default public InteractionResult tryAddToCrucible(UseOnContext context) {
        CrucibleBlockEntity crucible = (CrucibleBlockEntity)context.getLevel().getBlockEntity(context.getClickedPos());
        if (crucible == null) {
            return InteractionResult.PASS;
        }
        CrucibleBlockEntity.insertPowerBottle(crucible, new PowerBottleInsertContext(context));
        return InteractionResult.SUCCESS;
    }
}

