/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.registration.ReactiveItems;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CrystalIronItem
extends Item {
    public CrystalIronItem(Item.Properties props) {
        super(props);
    }

    public static boolean effectNotBlocked(LivingEntity entity, int cost) {
        Player player;
        if (entity.isHolding((Item)ReactiveItems.CRYSTAL_IRON.get())) {
            if (cost > 0) {
                if (entity.getOffhandItem().is((Item)ReactiveItems.CRYSTAL_IRON.get())) {
                    entity.getOffhandItem().hurtAndBreak(cost, entity, entity.getEquipmentSlotForItem(entity.getOffhandItem()));
                } else {
                    entity.getMainHandItem().hurtAndBreak(cost, entity, entity.getEquipmentSlotForItem(entity.getMainHandItem()));
                }
            }
            return false;
        }
        if (entity instanceof Player && (player = (Player)entity).getInventory().hasAnyMatching(stack -> stack.is((Item)ReactiveItems.CRYSTAL_IRON.get()))) {
            if (cost > 0) {
                for (ItemStack stack2 : player.getInventory().items) {
                    if (!stack2.is((Item)ReactiveItems.CRYSTAL_IRON.get())) continue;
                    if (player instanceof ServerPlayer) {
                        stack2.hurtAndBreak(cost, (ServerLevel)player.level(), (LivingEntity)player, i -> {});
                    }
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 12;
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot_number, boolean unknown) {
        if (entity instanceof LivingEntity) {
            LivingEntity bearer = (LivingEntity)entity;
            if (!level.isClientSide) {
                if (bearer.getActiveEffects().isEmpty()) {
                    return;
                }
                EquipmentSlot slot = bearer.getEquipmentSlotForItem(stack);
                ArrayList<Holder> effects_to_remove = new ArrayList<Holder>(List.of(MobEffects.WITHER, MobEffects.POISON));
                if (WorldSpecificValue.getBool("stone_break_hunger", 0.7f)) {
                    effects_to_remove.add(MobEffects.HUNGER);
                }
                if (WorldSpecificValue.getBool("stone_break_slow", 0.3f)) {
                    effects_to_remove.add(MobEffects.MOVEMENT_SLOWDOWN);
                }
                if (WorldSpecificValue.getBool("stone_break_weakness", 0.5f)) {
                    effects_to_remove.add(MobEffects.WEAKNESS);
                }
                for (Holder effect : effects_to_remove) {
                    if (!bearer.removeEffect(effect)) continue;
                    stack.hurtAndBreak(1, bearer, slot);
                }
            }
        }
    }
}

