/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.advancements.FlagTrigger;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionStatusEntry;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.blocks.CrucibleBlock;
import dev.hyperlynx.reactive.components.LitmusMeasurement;
import dev.hyperlynx.reactive.net.LitmusScreenPayload;
import dev.hyperlynx.reactive.registration.ReactiveComponentTypes;
import dev.hyperlynx.reactive.registration.ReactiveCriterionTriggers;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class LitmusPaperItem
extends Item {
    public LitmusPaperItem(Item.Properties props) {
        super(props.stacksTo(1));
    }

    private void appendReactionText(Player player, List<Component> text, LitmusMeasurement measurement) {
        for (ReactionStatusEntry entry : measurement.statuses()) {
            switch (entry.status()) {
                case STABLE: {
                    text.add((Component)Component.translatable((String)"text.reactive.stable"));
                    break;
                }
                case VOLATILE: {
                    text.add((Component)this.getReactionOrUnknownComponent(entry, player).append((Component)Component.translatable((String)"text.reactive.single_power_reaction_missing_condition").withStyle(ChatFormatting.GRAY)));
                    break;
                }
                case POWER_TOO_WEAK: {
                    text.add((Component)this.getReactionOrUnknownComponent(entry, player).append((Component)Component.translatable((String)"text.reactive.power_too_weak").withStyle(ChatFormatting.GRAY)));
                    break;
                }
                case MISSING_STIMULUS: {
                    text.add((Component)this.getReactionOrUnknownComponent(entry, player).append((Component)Component.translatable((String)"text.reactive.multi_power_reaction_missing_condition").withStyle(ChatFormatting.GRAY)));
                    break;
                }
                case MISSING_CATALYST: {
                    text.add((Component)this.getReactionOrUnknownComponent(entry, player).append((Component)Component.translatable((String)"text.reactive.missing_catalyst").withStyle(ChatFormatting.GRAY)));
                    break;
                }
                case INHIBITED: {
                    text.add((Component)this.getReactionOrUnknownComponent(entry, player).append((Component)Component.translatable((String)"text.reactive.inhibited").withStyle(ChatFormatting.GRAY)));
                    break;
                }
                case REACTING: {
                    text.add((Component)this.getReactionOrUnknownComponent(entry, player).append((Component)Component.translatable((String)"text.reactive.reacting").withStyle(ChatFormatting.BOLD)));
                }
            }
        }
    }

    private MutableComponent getReactionOrUnknownComponent(String reaction_alias, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer splayer = (ServerPlayer)player;
            if (splayer.getAdvancements().getOrStartProgress(Advancement.Builder.advancement().build(ReactiveMod.location("reactions/" + reaction_alias))).isDone()) {
                return ReactiveMod.REACTION_MAN.get(player.level(), reaction_alias).getName();
            }
            return Component.translatable((String)"reaction.reactive.unknown");
        }
        return Component.literal((String)"Error");
    }

    private MutableComponent getReactionOrUnknownComponent(ReactionStatusEntry entry, Player player) {
        return this.getReactionOrUnknownComponent(entry.reaction_alias(), player);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> hover_text, TooltipFlag tooltip_flag) {
        super.appendHoverText(stack, context, hover_text, tooltip_flag);
        if (stack.has(ReactiveComponentTypes.LITMUS_MEASUREMENT)) {
            if (((Boolean)ConfigMan.COMMON.litmusScreen.get()).booleanValue()) {
                hover_text.add((Component)Component.translatable((String)"text.reactive.litmus_instructions"));
            } else {
                hover_text.add((Component)Component.translatable((String)"text.reactive.litmus_instructions_1"));
                hover_text.add((Component)Component.translatable((String)"text.reactive.litmus_instructions_2"));
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!stack.has(ReactiveComponentTypes.LITMUS_MEASUREMENT)) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        if (((Boolean)ConfigMan.COMMON.litmusScreen.get()).booleanValue()) {
            LitmusMeasurement measurement = (LitmusMeasurement)stack.get(ReactiveComponentTypes.LITMUS_MEASUREMENT);
            this.showScreen(player, measurement);
        } else {
            for (Component line : this.buildMeasurementText(player.getItemInHand(hand), player)) {
                player.sendSystemMessage(line);
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (!(context.getLevel().getBlockState(context.getClickedPos()).getBlock() instanceof CrucibleBlock)) {
            return InteractionResult.PASS;
        }
        CrucibleBlockEntity crucible = (CrucibleBlockEntity)context.getLevel().getBlockEntity(context.getClickedPos());
        if (crucible == null) {
            return InteractionResult.PASS;
        }
        LitmusPaperItem.takeMeasurement(context.getItemInHand(), crucible);
        if (((Boolean)ConfigMan.COMMON.litmusScreen.get()).booleanValue()) {
            LitmusMeasurement measurement = (LitmusMeasurement)context.getItemInHand().get(ReactiveComponentTypes.LITMUS_MEASUREMENT);
            this.showScreen(context.getPlayer(), measurement);
        }
        return InteractionResult.SUCCESS;
    }

    private void showScreen(Player player, LitmusMeasurement measurement) {
        if (player instanceof ServerPlayer) {
            ServerPlayer splayer = (ServerPlayer)player;
            if (measurement.measurements().stream().anyMatch(line -> Objects.equals(line.power(), Powers.OMEN_POWER.getKey()))) {
                ((FlagTrigger)((Object)ReactiveCriterionTriggers.ISOLATE_OMEN.get())).trigger(splayer);
            }
            ArrayList<Component> reaction_text = new ArrayList<Component>();
            this.appendReactionText(player, reaction_text, measurement);
            PacketDistributor.sendToPlayer((ServerPlayer)splayer, (CustomPacketPayload)new LitmusScreenPayload(measurement, reaction_text), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void takeMeasurement(ItemStack paper, CrucibleBlockEntity crucible) {
        ArrayList<LitmusMeasurement.Line> lines = new ArrayList<LitmusMeasurement.Line>();
        for (Power power : crucible.getPowerMap().keySet()) {
            int power_level = crucible.getPowerLevel(power);
            if (power_level == 0) continue;
            lines.add(new LitmusMeasurement.Line((ResourceKey<Power>)((ResourceKey)Powers.POWER_REGISTRY.getResourceKey((Object)power).orElseThrow()), power.getName().toUpperCase() + " - " + LitmusPaperItem.getPercent(power_level)));
        }
        paper.set((DataComponentType)ReactiveComponentTypes.LITMUS_MEASUREMENT.get(), (Object)new LitmusMeasurement(lines, crucible.reaction_status, crucible.integrity < 85));
    }

    @NotNull
    public static String getPercent(int pow) {
        return pow > 16 ? pow / 16 + "%" : Component.translatable((String)"text.reactive.trace").getString();
    }

    private List<Component> buildMeasurementText(ItemStack stack, Player player) {
        boolean mode;
        ArrayList<Component> text = new ArrayList<Component>();
        LitmusMeasurement measurement = (LitmusMeasurement)stack.get((DataComponentType)ReactiveComponentTypes.LITMUS_MEASUREMENT.get());
        if (measurement == null) {
            return text;
        }
        boolean bl = mode = !player.isShiftKeyDown();
        if (mode) {
            if (player.level().isClientSide) {
                text.add((Component)Component.translatable((String)"text.reactive.measurement_header").withStyle(ChatFormatting.GRAY));
                for (LitmusMeasurement.Line line : measurement.measurements()) {
                    TextColor color = TextColor.fromRgb((int)0xFFFFFF);
                    if (((Boolean)ConfigMan.CLIENT.colorizeLitmusOutput.get()).booleanValue()) {
                        Power power = (Power)Powers.POWER_REGISTRY.get(line.power());
                        if (power != null) {
                            color = power.getTextColor();
                        }
                        if (power == Powers.OMEN_POWER.get() && player instanceof ServerPlayer) {
                            ServerPlayer splayer = (ServerPlayer)player;
                            ((FlagTrigger)((Object)ReactiveCriterionTriggers.ISOLATE_OMEN.get())).trigger(splayer);
                        }
                    }
                    text.add((Component)Component.literal((String)line.line()).withStyle(Style.EMPTY.withColor(color)));
                }
                if (measurement.measurements().isEmpty()) {
                    text.add((Component)Component.translatable((String)"text.reactive.measurement_empty").withStyle((Boolean)ConfigMan.CLIENT.colorizeLitmusOutput.get() != false ? Style.EMPTY.withColor(BiomeColors.getAverageWaterColor((BlockAndTintGetter)player.level(), (BlockPos)player.getOnPos())) : Style.EMPTY));
                }
                if (measurement.integrity_violated()) {
                    text.add((Component)Component.translatable((String)"text.reactive.litmus_integrity_failure").withStyle((Boolean)ConfigMan.CLIENT.colorizeLitmusOutput.get() != false ? ChatFormatting.DARK_RED : ChatFormatting.WHITE));
                }
            }
        } else if (!player.level().isClientSide) {
            this.appendReactionText(player, text, measurement);
        }
        return text;
    }
}

