/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.material.ClientMaterialMan;
import dev.hyperlynx.reactive.alchemy.material.Material;
import dev.hyperlynx.reactive.alchemy.material.MaterialMan;
import dev.hyperlynx.reactive.alchemy.material.MaterialModel;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperty;
import dev.hyperlynx.reactive.alchemy.material.formula.Formula;
import dev.hyperlynx.reactive.registration.ReactiveComponentTypes;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import dev.hyperlynx.reactive.util.Color;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class MaterialItem
extends BlockItem {
    private static final int MAX_NOTES_TOOLTIP_LINE_LENGTH = 32;

    public MaterialItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public Component getName(ItemStack stack) {
        if (stack.has((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get())) {
            return ClientMaterialMan.getName(Objects.requireNonNull((ResourceLocation)stack.get((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get())));
        }
        return Component.translatable((String)"block.reactive.invalid_material");
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        Component discoverer;
        Object first_notes_line;
        super.appendHoverText(stack, context, components, flag);
        if (!stack.has((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get())) {
            components.add((Component)Component.translatable((String)"text.reactive.random_material_tooltip"));
            return;
        }
        Material material = MaterialMan.fetch(context.level(), (ResourceLocation)stack.get((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get()));
        if (material.getNotes().isPresent() && !((String)(first_notes_line = material.getNotes().get().lines().findFirst().orElse(""))).isEmpty()) {
            if (((String)first_notes_line).length() > 32) {
                first_notes_line = ((String)first_notes_line).substring(0, 32);
                first_notes_line = (String)first_notes_line + "...";
            }
            components.add((Component)Component.literal((String)first_notes_line).withStyle(ChatFormatting.GRAY));
        }
        if (flag.hasShiftDown() && !(discoverer = material.getDiscovererName(context.level())).equals((Object)Component.empty())) {
            components.add(discoverer);
        }
        if (flag.isAdvanced()) {
            components.add((Component)Component.literal((String)String.valueOf(stack.get((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get()))).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public static int getItemColor(ItemStack stack, int ignored) {
        if (stack.has((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get())) {
            return ClientMaterialMan.data().get((ResourceLocation)stack.get((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get())).getOrDefault((MaterialProperty)MaterialProperties.COLOR.get(), Color.white()).hex();
        }
        return 0;
    }

    public static float getModelOverrideValue(ItemStack stack, Level level, LivingEntity ignored, long ignoredSeed) {
        if (!stack.has((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get())) {
            return 0.0f;
        }
        Material material = MaterialMan.fetch(level, (ResourceLocation)stack.get((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get()));
        return MaterialModel.fromName(material.getOrDefault((MaterialProperty)MaterialProperties.MODEL_NAME.get(), "SALT")).getModelIndex();
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        ResourceLocation id;
        if (level.isClientSide()) {
            return;
        }
        if (!stack.has((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get())) {
            ResourceLocation random_material_id = MaterialMan.createOrFetchByFormula(level, new Formula(Power.generateRandomPowerCombo(level), (Holder<Item>)ReactiveItems.SALT_BLOCK));
            stack.set((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get(), (Object)random_material_id);
        }
        if (!MaterialMan.occupied(level, id = (ResourceLocation)stack.get((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get()))) {
            stack.remove((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get());
        }
    }
}

