/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.special.SpecialCaseMan;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.blocks.CrucibleBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class QuartzBottleItem
extends Item {
    private static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        @NotNull
        public ItemStack dispense(BlockSource source, @NotNull ItemStack stack) {
            BlockPos target = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
            if (!(source.level().getBlockState(target).getBlock() instanceof CrucibleBlock)) {
                return this.defaultDispenseItemBehavior.dispense(source, stack);
            }
            CrucibleBlockEntity crucible = (CrucibleBlockEntity)source.level().getBlockEntity(target);
            if (crucible == null) {
                return this.defaultDispenseItemBehavior.dispense(source, stack);
            }
            for (Power p : crucible.getPowerMap().keySet()) {
                if (!p.hasBottle() || crucible.getPowerLevel(p) <= 600) continue;
                crucible.expendPower(p, 600);
                stack.shrink(1);
                source.level().playSound(null, source.pos(), SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 0.8f, 1.0f);
                ItemEntity power_bottle_drop = new ItemEntity((Level)source.level(), (double)target.getX() + 0.5, (double)target.getY() + 0.6, (double)target.getZ() + 0.5, SpecialCaseMan.checkBottleSpecialCases(crucible, p.getBottle()));
                source.level().addFreshEntity((Entity)power_bottle_drop);
            }
            crucible.setDirty();
            return stack;
        }
    };

    public QuartzBottleItem(Item.Properties props) {
        super(props);
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)DISPENSE_ITEM_BEHAVIOR);
    }
}

