/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.blocks.AirLightBlock;
import dev.hyperlynx.reactive.client.particles.EnergyParticle;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.items.CrystalIronItem;
import dev.hyperlynx.reactive.items.StaffItem;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import dev.hyperlynx.reactive.registration.ReactiveComponentTypes;
import dev.hyperlynx.reactive.registration.ReactiveParticles;
import dev.hyperlynx.reactive.util.BeamHelper;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class StaffEffects {
    public static void radiance(Player user, ItemStack stack) {
        int range = (Integer)ConfigMan.COMMON.lightStaffRange.get();
        BlockHitResult block_hit = BeamHelper.playerRayTrace(user.level(), user, ClipContext.Fluid.NONE, ClipContext.Block.VISUAL, range);
        BlockPos block_hit_pos = block_hit.getBlockPos();
        Vec3 start = user.getEyePosition();
        Vec3 end = start.add(user.getLookAngle().scale((double)range));
        EntityHitResult entity_hit = ProjectileUtil.getEntityHitResult((Entity)user, (Vec3)start, (Vec3)end, (AABB)new AABB(start, end), e -> e instanceof LivingEntity, (double)Double.MAX_VALUE);
        if (user instanceof ServerPlayer) {
            Entity entity;
            ServerPlayer serveruser = (ServerPlayer)user;
            if (entity_hit != null && (entity = entity_hit.getEntity()) instanceof LivingEntity) {
                LivingEntity victim = (LivingEntity)entity;
                if (victim.isInvertedHealAndHarm()) {
                    victim.setRemainingFireTicks(300);
                    StaffItem.hurtVictim(serveruser, stack, (Entity)victim, user.damageSources().inFire(), ((Double)ConfigMan.COMMON.lightStaffPowerVsUndead.get()).floatValue());
                }
                victim.addEffect(new MobEffectInstance(MobEffects.GLOWING, 40, 0));
            }
            if (!block_hit.getType().equals((Object)HitResult.Type.MISS)) {
                BlockPos light_target = block_hit_pos.relative(block_hit.getDirection(), 1);
                if (!user.level().isLoaded(light_target)) {
                    return;
                }
                if (user.level().getBlockState(light_target).isAir() && !user.level().getBlockState(light_target).is((Block)ReactiveBlocks.GLOWING_AIR.get())) {
                    user.level().setBlock(light_target, (BlockState)((AirLightBlock)((Object)ReactiveBlocks.GLOWING_AIR.get())).defaultBlockState().setValue((Property)AirLightBlock.DECAYING, (Comparable)Boolean.valueOf((Boolean)ConfigMan.COMMON.lightStaffLightsPermanent.get() == false)), 11);
                } else if (user.level().getBlockState(light_target).is(Blocks.WATER)) {
                    user.level().setBlock(light_target, (BlockState)((BlockState)((AirLightBlock)((Object)ReactiveBlocks.GLOWING_AIR.get())).defaultBlockState().setValue((Property)AirLightBlock.DECAYING, (Comparable)Boolean.valueOf((Boolean)ConfigMan.COMMON.lightStaffLightsPermanent.get() == false))).setValue((Property)AirLightBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 11);
                }
                user.level().playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.BEACON_AMBIENT, SoundSource.PLAYERS, 0.4f, 1.2f);
            }
        } else {
            ParticleScribe.drawParticleLine(user.level(), (ParticleOptions)ParticleTypes.END_ROD, user.getEyePosition().x, user.getEyePosition().y - 0.4, user.getEyePosition().z, block_hit.getLocation().x, block_hit.getLocation().y, block_hit.getLocation().z, 2, 0.1);
        }
    }

    public static void blazing(Player user, ItemStack ignored) {
        int range = (Integer)ConfigMan.COMMON.blazeStaffRange.get();
        Vec3 start = user.getEyePosition();
        Vec3 end = start.add(user.getLookAngle().scale((double)range));
        EntityHitResult entityHit = ProjectileUtil.getEntityHitResult((Entity)user, (Vec3)start, (Vec3)end, (AABB)new AABB(start, end), e -> e instanceof LivingEntity, (double)Double.MAX_VALUE);
        if (user instanceof ServerPlayer) {
            Vec3 target = entityHit == null ? end : entityHit.getLocation();
            Level level = user.level();
            Vec3 fireball_position = start.add(user.getLookAngle().scale(1.5)).add(level.random.nextDouble() * 2.0 - 1.0, level.random.nextDouble() * 2.0 - 1.0, level.random.nextDouble() * 2.0 - 1.0);
            Vec3 aim = target.subtract(fireball_position).normalize().scale(0.1);
            Object fireball = (Integer)ConfigMan.COMMON.blazeStaffExplosionSize.get() > 0 ? new LargeFireball(level, (LivingEntity)user, aim, ((Integer)ConfigMan.COMMON.blazeStaffExplosionSize.get()).intValue()) : new SmallFireball(level, (LivingEntity)user, aim);
            fireball.setPos(fireball_position);
            level.addFreshEntity((Entity)fireball);
            level.playSound(null, fireball_position.x, fireball_position.y, fireball_position.z, SoundEvents.FIRECHARGE_USE, SoundSource.PLAYERS, 0.25f, 1.0f);
            ParticleScribe.drawExactParticleSphere(level, (ParticleOptions)ParticleTypes.FLAME, fireball_position, 0.0, 0.3, level.random.nextIntBetweenInclusive(1, 5));
        }
    }

    public static void spectral(Player user, ItemStack stack) {
        BlockHitResult blockHit = BeamHelper.playerRayTrace(user.level(), user, ClipContext.Fluid.NONE, ClipContext.Block.COLLIDER, ((Integer)ConfigMan.COMMON.soulStaffRange.get()).intValue());
        Vec3 blockHitPos = blockHit.getLocation();
        AABB aoe = new AABB(blockHitPos.subtract(1.0, 1.0, 1.0), blockHitPos.add(1.0, 1.0, 1.0));
        boolean wide = EnchantmentHelper.has((ItemStack)stack, (DataComponentType)((DataComponentType)ReactiveComponentTypes.WIDE_RANGE.value()));
        aoe = aoe.inflate(wide ? 2.5 : 1.5);
        if (user instanceof ServerPlayer) {
            ServerPlayer serveruser = (ServerPlayer)user;
            for (LivingEntity victim : user.level().getEntitiesOfClass(LivingEntity.class, aoe)) {
                if (victim instanceof ServerPlayer && !victim.equals((Object)user) && !CrystalIronItem.effectNotBlocked(victim, 1)) continue;
                StaffItem.hurtVictim(serveruser, stack, (Entity)victim, user.damageSources().magic(), ((Double)ConfigMan.COMMON.soulStaffPower.get()).floatValue());
                victim.knockback(0.3, user.level().random.nextDouble() * 0.2 - 0.1, user.level().random.nextDouble() * 0.2 - 0.1);
            }
            user.level().playSound(null, blockHitPos.x, blockHitPos.y, blockHitPos.z, (Holder)SoundEvents.SOUL_ESCAPE, SoundSource.PLAYERS, 0.5f, user.level().random.nextFloat() * 0.1f + 0.95f);
        } else {
            ParticleScribe.drawParticleBox(user.level(), (ParticleOptions)ParticleTypes.SOUL, aoe, wide ? 20 : 10);
            user.level().addParticle((ParticleOptions)ParticleTypes.SOUL, blockHitPos.x, blockHitPos.y, blockHitPos.z, 0.0, 0.0, 0.0);
        }
    }

    public static void missile(Player user, ItemStack stack) {
        if (user instanceof ServerPlayer) {
            ServerPlayer serveruser = (ServerPlayer)user;
            AABB aoe = new AABB(user.position().subtract(1.0, 1.0, 1.0), user.position().add(1.0, 1.0, 1.0));
            boolean super_missile = EnchantmentHelper.has((ItemStack)stack, (DataComponentType)((DataComponentType)ReactiveComponentTypes.WIDE_RANGE.value()));
            int base_range = (Integer)ConfigMan.COMMON.mindStaffRange.get();
            aoe = aoe.inflate(super_missile ? (double)base_range * 1.67 : (double)base_range);
            List nearby_ents = user.level().getEntitiesOfClass(LivingEntity.class, aoe);
            nearby_ents.remove(user);
            HashMap<LivingEntity, Integer> hit_counts = new HashMap<LivingEntity, Integer>();
            for (int i = 0; i < (super_missile ? (Integer)ConfigMan.COMMON.mindStaffEnchantedMissiles.get() : (Integer)ConfigMan.COMMON.mindStaffBaseMissiles.get()) && !nearby_ents.isEmpty(); ++i) {
                TamableAnimal tamable_victim;
                LivingEntity victim = (LivingEntity)nearby_ents.get(user.level().random.nextInt(0, nearby_ents.size()));
                if (victim.isDeadOrDying() || victim instanceof ArmorStand || victim instanceof TamableAnimal && (tamable_victim = (TamableAnimal)victim).getOwner() != null && tamable_victim.getOwner().equals((Object)user)) continue;
                hit_counts.put(victim, hit_counts.getOrDefault(victim, 0) + 1);
                if ((Integer)hit_counts.get(victim) < (Integer)ConfigMan.COMMON.mindStaffMaxHits.get()) continue;
                nearby_ents.remove(victim);
            }
            for (LivingEntity victim : hit_counts.keySet()) {
                for (int i = 0; i < (Integer)hit_counts.get(victim); ++i) {
                    ParticleScribe.drawParticleZigZag(user.level(), (ParticleOptions)ReactiveParticles.SMALL_RUNE, user.getX(), user.getEyeY() - 0.4, user.getZ(), victim.getX(), victim.getEyeY(), victim.getZ(), 2, 5, 0.7);
                    user.level().playSound(null, victim.getX(), victim.getEyeY(), victim.getZ(), SoundEvents.AMETHYST_BLOCK_STEP, SoundSource.PLAYERS, 0.3f, user.level().random.nextFloat() * 0.1f + 0.8f);
                }
                StaffItem.hurtVictim(serveruser, stack, (Entity)victim, user.damageSources().magic(), (float)((Integer)hit_counts.get(victim)).intValue() * ((Double)ConfigMan.COMMON.mindStaffPower.get()).floatValue());
            }
        }
    }

    public static void living(Player user, ItemStack ignored) {
        AABB aoe = new AABB(user.position().subtract(1.0, 1.0, 1.0), user.position().add(1.0, 1.0, 1.0));
        aoe = aoe.inflate((double)((Integer)ConfigMan.COMMON.vitalStaffRange.get()).intValue());
        if ((double)user.level().random.nextFloat() < 0.4) {
            List nearby_ents = user.level().getEntitiesOfClass(LivingEntity.class, aoe);
            for (LivingEntity victim : nearby_ents) {
                boolean has_regen = false;
                boolean has_hp_up = false;
                for (MobEffectInstance mei : victim.getActiveEffects()) {
                    if (mei.getEffect().equals((Object)MobEffects.HEALTH_BOOST)) {
                        mei.update(new MobEffectInstance(MobEffects.HEALTH_BOOST, 500, (Integer)ConfigMan.COMMON.vitalStaffHealthBoost.get() - 1));
                        has_hp_up = true;
                        continue;
                    }
                    if (!mei.getEffect().equals((Object)MobEffects.REGENERATION)) continue;
                    mei.update(new MobEffectInstance(MobEffects.REGENERATION, 50, (Integer)ConfigMan.COMMON.vitalStaffRegeneration.get() - 1));
                    has_regen = true;
                }
                if (!has_hp_up) {
                    victim.addEffect(new MobEffectInstance(MobEffects.HEALTH_BOOST, 500, (Integer)ConfigMan.COMMON.vitalStaffHealthBoost.get() - 1));
                }
                if (has_regen) continue;
                victim.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 50, (Integer)ConfigMan.COMMON.vitalStaffRegeneration.get() - 1));
            }
        }
        if (user.level().isClientSide) {
            ParticleScribe.drawParticleBox(user.level(), (ParticleOptions)new EnergyParticle.Options(0.1f, ((Power)Powers.VITAL_POWER.get()).getColor(), user.getEyePosition(), (double)user.level().random.nextFloat() > 0.2, true), aoe.deflate(3.0), 5);
        }
        user.level().playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.BEACON_AMBIENT, SoundSource.PLAYERS, 0.7f, 1.3f);
    }
}

