/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.blocks.SymbolBlock;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;

public class SymbolItem
extends BlockItem {
    private static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){

        public ItemStack execute(BlockSource target_source, ItemStack stack) {
            Direction direction = (Direction)target_source.state().getValue((Property)DispenserBlock.FACING);
            BlockPos pos = target_source.pos().relative(direction);
            SymbolItem symbol = (SymbolItem)stack.getItem();
            symbol.place((BlockPlaceContext)new DirectionalPlaceContext((Level)target_source.level(), pos, direction, stack, direction));
            return stack;
        }
    };

    public SymbolItem(Block block, Item.Properties props) {
        super(block, props);
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)DISPENSE_ITEM_BEHAVIOR);
    }

    public static DeferredItem<SymbolItem> registerSimpleBlockItem(DeferredHolder<Block, SymbolBlock> block) {
        return ReactiveItems.ITEMS.register(block.getId().getPath(), () -> new SymbolItem((Block)block.get(), new Item.Properties()));
    }
}

