/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.items.PowerBottleItem;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Allay.class})
public abstract class AllayMixin {
    Optional<BlockPos> symbol_maybe = Optional.empty();
    private static final EntityDataAccessor<Boolean> DATA_CAN_DONATE = SynchedEntityData.defineId(Allay.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    int symbol_cache_ticker = 0;
    boolean unredeemed_duplication = false;

    @Inject(method={"defineSynchedData"}, at={@At(value="RETURN")})
    public void defineSynchedData(CallbackInfo ci, @Local SynchedEntityData.Builder builder) {
        builder.define(DATA_CAN_DONATE, (Object)true);
    }

    @Inject(method={"duplicateAllay"}, at={@At(value="RETURN")})
    public void duplicateAllay(CallbackInfo ci) {
        this.unredeemed_duplication = true;
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    public void tick(CallbackInfo ci) {
        ++this.symbol_cache_ticker;
        if (this.symbol_cache_ticker > (Integer)ConfigMan.COMMON.crucibleTickDelay.get()) {
            this.symbol_maybe = BlockPos.findClosestMatch((BlockPos)((Allay)this).blockPosition(), (int)10, (int)10, blockPos -> ((Allay)this).level().getBlockState(blockPos).is((Block)ReactiveBlocks.IRON_SYMBOL.get()));
            this.symbol_cache_ticker = 0;
        }
        if (this.symbol_maybe.isPresent()) {
            ((Allay)this).hurt(((Allay)this).level().damageSources().magic(), 4.0f);
        }
        if (((Allay)this).getItemInHand(InteractionHand.MAIN_HAND).is((Item)ReactiveItems.CRYSTAL_IRON.get())) {
            ((Allay)this).hurt(((Allay)this).level().damageSources().magic(), 10.0f);
        }
        if (((Allay)this).getItemInHand(InteractionHand.MAIN_HAND).is((Item)ReactiveItems.QUARTZ_BOTTLE.get()) && this.unredeemed_duplication) {
            ((Allay)this).level().playSound(null, ((Allay)this).blockPosition(), SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 0.8f, 1.1f);
            ((Allay)this).setItemInHand(InteractionHand.MAIN_HAND, ((PowerBottleItem)ReactiveItems.SOUL_BOTTLE.get()).getDefaultInstance());
            ((Allay)this).getEntityData().set(DATA_CAN_DONATE, (Object)false);
            this.unredeemed_duplication = false;
        }
    }
}

