/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.mixin;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.advancements.FlagTrigger;
import dev.hyperlynx.reactive.items.CrystalIronItem;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import dev.hyperlynx.reactive.registration.ReactiveCriterionTriggers;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityHarmUndeadMixin {
    Optional<BlockPos> symbol_maybe = Optional.empty();
    int symbol_cache_ticker = 0;

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    public void hurtUndeadWithDivineSymbolOnTick(CallbackInfo ci) {
        if (((LivingEntity)this).isInvertedHealAndHarm()) {
            ++this.symbol_cache_ticker;
            if (this.symbol_cache_ticker > (Integer)ConfigMan.COMMON.crucibleTickDelay.get() * 5) {
                this.symbol_maybe = BlockPos.findClosestMatch((BlockPos)((LivingEntity)this).blockPosition(), (int)6, (int)6, blockPos -> ((LivingEntity)this).level().getBlockState(blockPos).is((Block)ReactiveBlocks.DIVINE_SYMBOL.get()));
                this.symbol_cache_ticker = 0;
            }
            if (this.symbol_maybe.isPresent() && CrystalIronItem.effectNotBlocked((LivingEntity)this, 1)) {
                ((LivingEntity)this).hurt(((LivingEntity)this).level().damageSources().magic(), 1.0f);
                LivingEntity livingEntity = (LivingEntity)this;
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)livingEntity;
                    player.displayClientMessage((Component)Component.translatable((String)"message.reactive.undead_player_divine_hurt"), true);
                    ((FlagTrigger)((Object)ReactiveCriterionTriggers.UNDEAD_PLAYER_DIVINE_HURT.get())).trigger(player);
                }
            } else if (this.symbol_maybe.isPresent()) {
                this.symbol_maybe = Optional.empty();
            }
        }
    }
}

