/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.net;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.material.MaterialMan;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MaterialNotesPayload(ResourceLocation material_id, String notes) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MaterialNotesPayload> TYPE = new CustomPacketPayload.Type(ReactiveMod.location("material_update_notes"));
    public static final StreamCodec<? super FriendlyByteBuf, MaterialNotesPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, MaterialNotesPayload::material_id, (StreamCodec)ByteBufCodecs.STRING_UTF8, MaterialNotesPayload::notes, MaterialNotesPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        Level level = context.player().level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel slevel = (ServerLevel)level;
        MaterialMan.fetch((Level)slevel, this.material_id).setNotes(this.notes);
        MaterialMan.data((Level)slevel).setDirty();
    }
}

