/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.net;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.net.ReactionPagePayload;
import dev.hyperlynx.reactive.net.ReactionPageRequestPayload;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ReactionPageFetcher {
    private static final ConcurrentMap<String, Semaphore> REQUEST_BLOCKERS = new ConcurrentHashMap<String, Semaphore>();
    private static final ConcurrentMap<String, String> RESPONSES = new ConcurrentHashMap<String, String>();

    public static String requestFormulaFor(String alias) throws InterruptedException {
        boolean success;
        if (RESPONSES.containsKey(alias)) {
            return (String)RESPONSES.get(alias);
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new ReactionPageRequestPayload(alias), (CustomPacketPayload[])new CustomPacketPayload[0]);
        ReactiveMod.LOGGER.debug("Requested formula for {}", (Object)alias);
        if (!REQUEST_BLOCKERS.containsKey(alias)) {
            REQUEST_BLOCKERS.put(alias, new Semaphore(0, false));
        }
        if (!(success = ((Semaphore)REQUEST_BLOCKERS.get(alias)).tryAcquire(1L, TimeUnit.SECONDS))) {
            ReactiveMod.LOGGER.error("Timeout loading contents for the reaction formula for {}", (Object)alias);
            return "$(4) Timeout while loading";
        }
        return (String)RESPONSES.get(alias);
    }

    public static void handlePageResponse(ReactionPagePayload payload, IPayloadContext ignored) {
        ReactiveMod.LOGGER.debug("Received response for page about {}", (Object)payload.alias());
        RESPONSES.put(payload.alias(), payload.contents());
        if (!REQUEST_BLOCKERS.containsKey(payload.alias())) {
            REQUEST_BLOCKERS.put(payload.alias(), new Semaphore(0, false));
        }
        ((Semaphore)REQUEST_BLOCKERS.get(payload.alias())).release();
    }
}

