/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.net;

import com.mojang.datafixers.util.Either;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionStatusEntry;
import dev.hyperlynx.reactive.alchemy.rxn.Reactor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ReactionStatusPayload(List<ReactionStatusEntry> statuses, Target target) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ReactionStatusPayload> TYPE = new CustomPacketPayload.Type(ReactiveMod.location("reaction_sync_payload"));
    public static final StreamCodec<FriendlyByteBuf, ReactionStatusPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.collection(ArrayList::new, ReactionStatusEntry.STREAM_CODEC), ReactionStatusPayload::statuses, Target.STREAM_CODEC, ReactionStatusPayload::target, ReactionStatusPayload::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ReactionStatusPayload payload, IPayloadContext context) {
        Level level = context.player().level();
        Reactor reactor = payload.target().getReactor(level);
        if (reactor == null) {
            return;
        }
        reactor.clearRenderReactions();
        for (ReactionStatusEntry entry : payload.statuses()) {
            if (entry.status() != Reaction.Status.REACTING) continue;
            reactor.addRenderReaction(entry.reaction_alias());
        }
    }

    public record Target(Either<BlockPos, Integer> target) {
        public static final StreamCodec<FriendlyByteBuf, Target> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.either((StreamCodec)BlockPos.STREAM_CODEC, (StreamCodec)ByteBufCodecs.INT), Target::target, Target::new);

        @Nullable
        public Reactor getReactor(Level level) {
            if (this.target.left().isPresent()) {
                BlockEntity be = level.getBlockEntity((BlockPos)this.target.left().get());
                if (!(be instanceof Reactor)) {
                    ReactiveMod.LOGGER.error("Sent reaction status to invalid reactor block entity. Ignoring.");
                    return null;
                }
                Reactor reactor = (Reactor)be;
                return reactor;
            }
            if (this.target.right().isPresent()) {
                Entity entity = level.getEntity(((Integer)this.target.right().get()).intValue());
                if (!(entity instanceof Reactor)) {
                    ReactiveMod.LOGGER.error("Sent reaction status to invalid entity. Ignoring.");
                    return null;
                }
                Reactor reactor = (Reactor)entity;
                return reactor;
            }
            ReactiveMod.LOGGER.error("Sent malformed reaction status. Ignoring.");
            return null;
        }
    }
}

