/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.recipes;

import dev.hyperlynx.reactive.alchemy.Power;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import org.jetbrains.annotations.NotNull;

public class CrucibleRecipeInput
implements RecipeInput {
    ItemStack item;
    Map<Power, Integer> reagents;

    public static CrucibleRecipeInput of(ItemStack stack) {
        CrucibleRecipeInput input = new CrucibleRecipeInput();
        input.item = stack;
        return input;
    }

    public static CrucibleRecipeInput of(ItemStack stack, Map<Power, Integer> powers) {
        CrucibleRecipeInput input = new CrucibleRecipeInput();
        input.item = stack;
        input.reagents = powers;
        return input;
    }

    public static CrucibleRecipeInput of(Map<Power, Integer> powers) {
        CrucibleRecipeInput input = new CrucibleRecipeInput();
        input.item = ItemStack.EMPTY;
        input.reagents = powers;
        return input;
    }

    @NotNull
    public ItemStack getItem() {
        return this.item;
    }

    @NotNull
    public ItemStack getItem(int i) {
        return this.getItem();
    }

    public int getPowerLevel(Power p) {
        if (this.reagents.containsKey(p)) {
            return this.reagents.get(p);
        }
        return 0;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return this.item.isEmpty();
    }
}

