/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.recipes.PrecipitateRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class PrecipitateRecipeSerializer
implements RecipeSerializer<PrecipitateRecipe> {
    public static final MapCodec<PrecipitateRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"transmute").forGetter(PrecipitateRecipe::getGroup), (App)ItemStack.CODEC.fieldOf("product").forGetter(PrecipitateRecipe::getProduct), (App)((Registry)Powers.POWERS.getRegistry().get()).byNameCodec().listOf().fieldOf("reagents").forGetter(PrecipitateRecipe::getReagents), (App)Codec.INT.fieldOf("min").forGetter(PrecipitateRecipe::getMinimum), (App)Codec.INT.fieldOf("cost").forGetter(PrecipitateRecipe::getCost), (App)Codec.INT.fieldOf("reagent_count").forGetter(PrecipitateRecipe::getReagentCount), (App)Codec.BOOL.optionalFieldOf("needs_electricity", (Object)false).forGetter(PrecipitateRecipe::isElectricityRequired)).apply((Applicative)instance, PrecipitateRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PrecipitateRecipe> STREAM_CODEC = StreamCodec.of(PrecipitateRecipeSerializer::toNetwork, PrecipitateRecipeSerializer::fromNetwork);

    public MapCodec<PrecipitateRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, PrecipitateRecipe> streamCodec() {
        return STREAM_CODEC;
    }

    @NotNull
    public static PrecipitateRecipe fromNetwork(@NotNull RegistryFriendlyByteBuf buffer) {
        ItemStack product = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        List reagent_locations = (List)buffer.readCollection(ArrayList::new, FriendlyByteBuf::readResourceLocation);
        ArrayList<Power> reagents = new ArrayList<Power>();
        for (ResourceLocation location : reagent_locations) {
            reagents.add((Power)((Registry)Powers.POWERS.getRegistry().get()).get(location));
        }
        int min = buffer.readInt();
        int cost = buffer.readInt();
        int reagent_count = buffer.readInt();
        boolean needs_electricity = buffer.readBoolean();
        return new PrecipitateRecipe("precipitation", product, reagents, min, cost, reagent_count, needs_electricity);
    }

    public static void toNetwork(@NotNull RegistryFriendlyByteBuf buffer, @NotNull PrecipitateRecipe recipe) {
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.product);
        buffer.writeCollection(recipe.reagents, (b, p) -> b.writeResourceLocation(p.getResourceLocation()));
        buffer.writeInt(recipe.minimum);
        buffer.writeInt(recipe.cost);
        buffer.writeInt(recipe.reagent_count);
        buffer.writeBoolean(recipe.needs_electricity);
    }
}

