/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.recipes;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.PowerBearer;
import dev.hyperlynx.reactive.recipes.CrucibleRecipeInput;
import dev.hyperlynx.reactive.registration.ReactiveRecipes;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class TransmuteRecipe
implements Recipe<CrucibleRecipeInput> {
    protected final String group;
    protected final Ingredient reactant;
    protected final ItemStack product;
    protected final List<Power> reagents;
    final int cost;
    final int minimum;
    public final boolean needs_electricity;

    public TransmuteRecipe(String group, Ingredient reactant, ItemStack product, List<Power> reagents, int min, int cost, boolean needs_electricity) {
        this.group = group;
        this.reactant = reactant;
        this.product = product;
        this.reagents = reagents;
        this.minimum = min;
        this.cost = cost;
        this.needs_electricity = needs_electricity;
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    private boolean powerMet(CrucibleRecipeInput input) {
        int power_level = 0;
        boolean has_all_reagents = true;
        for (Power p : this.reagents) {
            if (input.getPowerLevel(p) == 0) {
                has_all_reagents = false;
                break;
            }
            power_level += input.getPowerLevel(p);
        }
        return has_all_reagents && power_level > this.minimum;
    }

    public ItemStack apply(ItemStack input, PowerBearer bearer) {
        int max_tfs = Integer.MAX_VALUE;
        if (this.cost > 0) {
            for (Power p : this.reagents) {
                max_tfs = Math.min(max_tfs, bearer.getPowerLevel(p) / (this.cost / this.reagents.size()));
                bearer.expendPower(p, this.cost / this.reagents.size() * input.getCount());
            }
        }
        ItemStack result = this.product.copy();
        result.setCount(Math.min(input.getCount(), max_tfs) * result.getCount());
        input.setCount(input.getCount() - Math.min(input.getCount(), max_tfs));
        return result;
    }

    public boolean matches(@NotNull CrucibleRecipeInput input, @NotNull Level level) {
        for (ItemStack i : this.reactant.getItems()) {
            if (!input.getItem().is(i.getItem())) continue;
            return this.powerMet(input);
        }
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull CrucibleRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.product.copy();
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.product;
    }

    public ItemStack getProduct() {
        return this.product;
    }

    public Ingredient getReactant() {
        return this.reactant;
    }

    public List<Power> getReagents() {
        return this.reagents;
    }

    public int getCost() {
        return this.cost;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public boolean isElectricityRequired() {
        return this.needs_electricity;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ReactiveRecipes.TRANS_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ReactiveRecipes.TRANS_RECIPE_TYPE.get();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public boolean isSpecial() {
        return true;
    }
}

