/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.recipes.TransmuteRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class TransmuteRecipeSerializer
implements RecipeSerializer<TransmuteRecipe> {
    public static final MapCodec<TransmuteRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"transmute").forGetter(TransmuteRecipe::getGroup), (App)Ingredient.CODEC_NONEMPTY.fieldOf("reactant").forGetter(TransmuteRecipe::getReactant), (App)ItemStack.CODEC.fieldOf("product").forGetter(TransmuteRecipe::getProduct), (App)((Registry)Powers.POWERS.getRegistry().get()).byNameCodec().listOf().fieldOf("reagents").forGetter(TransmuteRecipe::getReagents), (App)Codec.INT.fieldOf("min").forGetter(TransmuteRecipe::getMinimum), (App)Codec.INT.fieldOf("cost").forGetter(TransmuteRecipe::getCost), (App)Codec.BOOL.optionalFieldOf("needs_electricity", (Object)false).forGetter(TransmuteRecipe::isElectricityRequired)).apply((Applicative)instance, TransmuteRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TransmuteRecipe> STREAM_CODEC = StreamCodec.of(TransmuteRecipeSerializer::toNetwork, TransmuteRecipeSerializer::fromNetwork);

    public MapCodec<TransmuteRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, TransmuteRecipe> streamCodec() {
        return STREAM_CODEC;
    }

    @NotNull
    public static TransmuteRecipe fromNetwork(@NotNull RegistryFriendlyByteBuf buffer) {
        Ingredient reactant = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        ItemStack product = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        List reagent_locations = (List)buffer.readCollection(ArrayList::new, FriendlyByteBuf::readResourceLocation);
        ArrayList<Power> reagents = new ArrayList<Power>();
        for (ResourceLocation location : reagent_locations) {
            reagents.add((Power)((Registry)Powers.POWERS.getRegistry().get()).get(location));
        }
        int min = buffer.readVarInt();
        int cost = buffer.readVarInt();
        boolean needs_electricity = buffer.readBoolean();
        return new TransmuteRecipe("transmutation", reactant, product, reagents, min, cost, needs_electricity);
    }

    public static void toNetwork(@NotNull RegistryFriendlyByteBuf buffer, @NotNull TransmuteRecipe recipe) {
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.reactant);
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.product);
        buffer.writeCollection(recipe.reagents, (b, p) -> b.writeResourceLocation(p.getResourceLocation()));
        buffer.writeVarInt(recipe.minimum);
        buffer.writeVarInt(recipe.cost);
        buffer.writeBoolean(recipe.needs_electricity);
    }
}

