/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.registration;

import dev.hyperlynx.reactive.client.gui.ScreenOpener;
import dev.hyperlynx.reactive.entites.HoverQuilt;
import dev.hyperlynx.reactive.integration.kubejs.ReactiveKubeJSPlugin;
import dev.hyperlynx.reactive.net.HoverQuiltHeightPayload;
import dev.hyperlynx.reactive.net.HoverQuiltVelocityPayload;
import dev.hyperlynx.reactive.net.LitmusScreenPayload;
import dev.hyperlynx.reactive.net.MaterialBESyncPayload;
import dev.hyperlynx.reactive.net.MaterialDataSyncPayload;
import dev.hyperlynx.reactive.net.MaterialDataSyncRequestPayload;
import dev.hyperlynx.reactive.net.MaterialListScreenPayload;
import dev.hyperlynx.reactive.net.MaterialNotesPayload;
import dev.hyperlynx.reactive.net.MaterialRenamePayload;
import dev.hyperlynx.reactive.net.MaterialRenameScreenPayload;
import dev.hyperlynx.reactive.net.ReactionPageFetcher;
import dev.hyperlynx.reactive.net.ReactionPagePayload;
import dev.hyperlynx.reactive.net.ReactionPageRequestPayload;
import dev.hyperlynx.reactive.net.ReactionPageServer;
import dev.hyperlynx.reactive.net.ReactionStatusPayload;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import net.minecraft.server.network.ConfigurationTask;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.network.event.RegisterConfigurationTasksEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="reactive")
public class ReactivePayloadHandlers {
    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.configurationToClient(WorldSpecificValue.AlchemySeedData.TYPE, WorldSpecificValue.AlchemySeedData.STREAM_CODEC, (IPayloadHandler)new WorldSpecificValue.AlchemySeedPayloadHandler());
        registrar.commonToClient(LitmusScreenPayload.TYPE, LitmusScreenPayload.STREAM_CODEC, (payload, _context) -> {
            if (FMLLoader.getDist() == Dist.CLIENT) {
                ScreenOpener.litmus(payload);
            }
        });
        registrar.commonToClient(ReactionStatusPayload.TYPE, ReactionStatusPayload.STREAM_CODEC, ReactionStatusPayload::handle);
        registrar.playToServer(ReactionPageRequestPayload.TYPE, ReactionPageRequestPayload.STREAM_CODEC, ReactionPageServer::handlePageRequest);
        registrar.playToServer(MaterialDataSyncRequestPayload.TYPE, MaterialDataSyncRequestPayload.STREAM_CODEC, MaterialDataSyncRequestPayload::handle);
        registrar.playToServer(MaterialRenamePayload.TYPE, MaterialRenamePayload.STREAM_CODEC, MaterialRenamePayload::handle);
        registrar.commonToClient(MaterialRenameScreenPayload.TYPE, MaterialRenameScreenPayload.STREAM_CODEC, (payload, _context) -> {
            if (FMLLoader.getDist() == Dist.CLIENT) {
                ScreenOpener.materialRename(payload.material_id());
            }
        });
        registrar.playToServer(MaterialNotesPayload.TYPE, MaterialNotesPayload.STREAM_CODEC, MaterialNotesPayload::handle);
        registrar.commonToClient(MaterialListScreenPayload.TYPE, MaterialListScreenPayload.STREAM_CODEC, (payload, _context) -> {
            if (FMLLoader.getDist() == Dist.CLIENT) {
                ScreenOpener.materialList();
            }
        });
        registrar.playToServer(HoverQuiltVelocityPayload.TYPE, HoverQuiltVelocityPayload.STREAM_CODEC, HoverQuilt::handleInputPacket);
        registrar.playToClient(HoverQuiltHeightPayload.TYPE, HoverQuiltHeightPayload.STREAM_CODEC, HoverQuilt::handleHeightPacket);
        registrar.playToClient(MaterialBESyncPayload.TYPE, MaterialBESyncPayload.STREAM_CODEC, MaterialBESyncPayload::handle);
        PayloadRegistrar async_registrar = event.registrar("1").executesOn(HandlerThread.NETWORK);
        async_registrar.commonToClient(ReactionPagePayload.TYPE, ReactionPagePayload.STREAM_CODEC, ReactionPageFetcher::handlePageResponse);
        async_registrar.playToClient(MaterialDataSyncPayload.TYPE, MaterialDataSyncPayload.STREAM_CODEC, MaterialDataSyncPayload::handle);
        if (ModList.get().isLoaded("kubejs")) {
            ReactiveKubeJSPlugin.registerPayloads(registrar);
        }
    }

    @SubscribeEvent
    public static void register(RegisterConfigurationTasksEvent event) {
        event.register((ConfigurationTask)new WorldSpecificValue.AlchemySeedConfigurationTask(event.getListener()));
    }
}

