/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.tests;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionStatusEntry;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;

@GameTestHolder(value="reactive")
public class CrucibleGameTests {
    @PrefixGameTestTemplate(value=false)
    @GameTest(template="crucible_test")
    public static void dissolveItemForPower(GameTestHelper helper) {
        BlockPos crucible_absolute_pos = helper.absolutePos(new BlockPos(0, 2, 0));
        ItemEntity shard = new ItemEntity((Level)helper.getLevel(), (double)crucible_absolute_pos.getX() + 0.5, (double)crucible_absolute_pos.getY() + 0.5265, (double)crucible_absolute_pos.getZ() + 0.5, Items.AMETHYST_SHARD.getDefaultInstance());
        shard.setPickUpDelay(50);
        shard.setDeltaMovement(0.0, 0.0, 0.0);
        helper.runAfterDelay(5L, () -> helper.getLevel().addFreshEntity((Entity)shard));
        helper.runAfterDelay(20L, () -> {
            BlockEntity patt0$temp = helper.getBlockEntity(new BlockPos(0, 2, 0));
            if (!(patt0$temp instanceof CrucibleBlockEntity)) {
                throw new GameTestAssertException("Crucible has wrong block entity");
            }
            CrucibleBlockEntity crucible = (CrucibleBlockEntity)patt0$temp;
            helper.assertTrue(crucible.getPowerLevel((Power)Powers.MIND_POWER.get()) > 0, "No power was added");
            helper.succeed();
        });
    }

    @PrefixGameTestTemplate(value=false)
    @GameTest(template="crucible_test")
    public static void dissolveItemForRecipe(GameTestHelper helper) {
        BlockPos crucible_absolute_pos = helper.absolutePos(new BlockPos(0, 2, 0));
        ItemEntity shard = new ItemEntity((Level)helper.getLevel(), (double)crucible_absolute_pos.getX() + 0.5, (double)crucible_absolute_pos.getY() + 0.5265, (double)crucible_absolute_pos.getZ() + 0.5, Items.AMETHYST_SHARD.getDefaultInstance());
        shard.setPickUpDelay(50);
        shard.setDeltaMovement(0.0, 0.0, 0.0);
        helper.runAfterDelay(5L, () -> helper.getLevel().addFreshEntity((Entity)shard));
        helper.runAfterDelay(20L, () -> {
            if (!(helper.getBlockEntity(new BlockPos(0, 2, 0)) instanceof CrucibleBlockEntity)) {
                throw new GameTestAssertException("Crucible has wrong block entity");
            }
            helper.assertTrue(!helper.getEntities(EntityType.ITEM).isEmpty(), "No residual item");
            helper.succeed();
        });
    }

    @PrefixGameTestTemplate(value=false)
    @GameTest(template="crucible_test")
    public static void transmuteRecipe(GameTestHelper helper) {
        BlockPos crucible_absolute_pos = helper.absolutePos(new BlockPos(0, 2, 0));
        ItemStack r = Items.REDSTONE.getDefaultInstance();
        r.setCount(64);
        ItemEntity redstone = new ItemEntity((Level)helper.getLevel(), (double)crucible_absolute_pos.getX() + 0.5, (double)crucible_absolute_pos.getY() + 0.5265, (double)crucible_absolute_pos.getZ() + 0.5, r);
        redstone.setPickUpDelay(50);
        redstone.setDeltaMovement(0.0, 0.0, 0.0);
        ItemStack input = Items.PAPER.getDefaultInstance();
        ItemEntity input_entity = new ItemEntity((Level)helper.getLevel(), (double)crucible_absolute_pos.getX() + 0.5, (double)crucible_absolute_pos.getY() + 0.5265, (double)crucible_absolute_pos.getZ() + 0.5, input);
        input_entity.setPickUpDelay(50);
        input_entity.setDeltaMovement(0.0, 0.0, 0.0);
        helper.runAfterDelay(5L, () -> helper.getLevel().addFreshEntity((Entity)redstone));
        helper.runAfterDelay(25L, () -> helper.getLevel().addFreshEntity((Entity)input_entity));
        helper.runAfterDelay(50L, () -> {
            if (!(helper.getBlockEntity(new BlockPos(0, 2, 0)) instanceof CrucibleBlockEntity)) {
                throw new GameTestAssertException("Crucible has wrong block entity");
            }
            helper.assertTrue(!helper.getEntities(EntityType.ITEM).isEmpty(), "No residual item");
            boolean could_fail = true;
            for (ItemEntity entity : helper.getEntities(EntityType.ITEM)) {
                if (!entity.getItem().is((Item)ReactiveItems.LITMUS_PAPER.get())) continue;
                helper.succeed();
                could_fail = false;
            }
            if (could_fail) {
                helper.fail("Transmutation did not occur");
            }
        });
    }

    @PrefixGameTestTemplate(value=false)
    @GameTest(template="crucible_test")
    public static void reaction(GameTestHelper helper) {
        BlockEntity blockEntity = helper.getBlockEntity(new BlockPos(0, 2, 0));
        if (!(blockEntity instanceof CrucibleBlockEntity)) {
            throw new GameTestAssertException("Crucible has wrong block entity");
        }
        CrucibleBlockEntity crucible = (CrucibleBlockEntity)blockEntity;
        crucible.addPower((Power)Powers.ASTRAL_POWER.get(), 100);
        helper.runAfterDelay(50L, () -> {
            List<ReactionStatusEntry> statuses = crucible.getReactionStatus();
            if (statuses.isEmpty()) {
                helper.fail("No reaction statuses!");
            }
            if (statuses.size() > 1) {
                helper.fail("A reaction other then astral occurred! Statuses: " + String.valueOf(statuses));
            }
            if (statuses.getFirst().reaction_alias().equals("astral") && statuses.getFirst().status().equals((Object)Reaction.Status.REACTING)) {
                helper.succeed();
            } else {
                helper.fail("A reaction other then astral occurred! Alias: " + statuses.getFirst().reaction_alias());
            }
        });
    }
}

