/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.util;

import dev.hyperlynx.reactive.ConfigMan;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class AreaMemory {
    final BlockPos hostPos;
    final Map<Block, BlockPos> model;
    final Map<TagKey<Block>, BlockPos> tag_model;
    BlockPos block_above_model;

    public AreaMemory(BlockPos hostPos) {
        this.hostPos = hostPos;
        this.model = new HashMap<Block, BlockPos>();
        this.tag_model = new HashMap<TagKey<Block>, BlockPos>();
    }

    public boolean exists(Level l, Block target) {
        return this.fetch(l, target) != null;
    }

    public BlockPos fetch(Level l, Block target) {
        BlockPos holder;
        if (this.model.containsKey(target) && l.getBlockState(holder = this.model.get(target)).is(target)) {
            return holder;
        }
        BlockPos newlyFound = this.findAndAddNearest(l, (int)((Integer)ConfigMan.COMMON.areaMemoryRange.get()), target);
        if (newlyFound != null) {
            this.model.put(target, newlyFound);
        }
        return newlyFound;
    }

    public BlockPos fetch(Level l, int radius, TagKey<Block> target) {
        BlockPos holder;
        if (this.tag_model.containsKey(target) && l.getBlockState(holder = this.tag_model.get(target)).is(target)) {
            return holder;
        }
        BlockPos newlyFound = this.findAndAddNearest(l, radius, target);
        if (newlyFound != null) {
            this.tag_model.put(target, newlyFound);
        }
        return newlyFound;
    }

    private BlockPos findAndAddNearest(Level l, int radius, Block target) {
        Optional found_maybe = BlockPos.findClosestMatch((BlockPos)this.hostPos, (int)radius, (int)radius, blockPos -> l.getBlockState(blockPos).is(target));
        return found_maybe.orElse(null);
    }

    private BlockPos findAndAddNearest(Level l, int radius, TagKey<Block> target) {
        Optional found_maybe = BlockPos.findClosestMatch((BlockPos)this.hostPos, (int)radius, (int)radius, blockPos -> l.getBlockState(blockPos).is(target));
        return found_maybe.orElse(null);
    }

    public boolean existsAbove(Level l, int range, Block target) {
        if (this.block_above_model != null && l.getBlockState(this.block_above_model).is(target)) {
            return true;
        }
        return this.fetchAbove(l, range, target) != null;
    }

    public BlockPos fetchAbove(Level l, int range, Block target) {
        for (int i = 1; i < range; ++i) {
            if (l.getBlockState(this.hostPos.above(i)).is(target)) {
                this.block_above_model = this.hostPos.above(i);
                return this.hostPos.above(i);
            }
            if (!AreaMemory.stateIsBlocking(l.getBlockState(this.hostPos.above(i)))) continue;
            return null;
        }
        return null;
    }

    public static boolean stateIsBlocking(BlockState state) {
        return !state.isAir() && (!(state.getBlock() instanceof TrapDoorBlock) || (Boolean)state.getValue((Property)TrapDoorBlock.OPEN) == false);
    }
}

