/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.util;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.ReactiveMod;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.network.configuration.ICustomConfigurationTask;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
public class WorldSpecificValue {
    public static long alchemy_seed = 0L;

    private static long getSeed() {
        if (ConfigMan.serverSpec.isLoaded() && ((Boolean)ConfigMan.SERVER.useCustomSeed.get()).booleanValue()) {
            return (Long)ConfigMan.SERVER.seed.get();
        }
        return alchemy_seed;
    }

    public static Random getSource(String alias) {
        long seed = WorldSpecificValue.getSeed();
        return new Random(seed + (long)alias.hashCode());
    }

    public static int get(String alias, int min, int max) {
        return WorldSpecificValue.getSource(alias).nextInt(max - min + 1) + min;
    }

    public static float get(String alias, float min, float max) {
        return WorldSpecificValue.getSource(alias).nextFloat(min, max);
    }

    public static boolean getBool(String alias, float chance) {
        return WorldSpecificValue.getSource(alias).nextFloat() < chance;
    }

    public static <T> T getFromCollection(String alias, Collection<T> c) {
        int index = WorldSpecificValue.get(alias, 0, c.size() - 1);
        int p = 0;
        for (T item : c) {
            if (p == index) {
                return item;
            }
            ++p;
        }
        System.err.println("Impossibly tried to pick too high an index @ hyperlynx.reactive.util.WorldSpecificValue");
        return null;
    }

    public static <T> ArrayList<T> shuffle(String alias, List<T> list) {
        ArrayList<T> input = new ArrayList<T>(list);
        ArrayList<T> output = new ArrayList<T>();
        for (int i = 0; i < list.size(); ++i) {
            int x = WorldSpecificValue.get(alias + i, 0, input.size() - 1);
            output.add(input.get(x));
            input.remove(x);
        }
        return output;
    }

    @SubscribeEvent
    public static void worldLoad(LevelEvent.Load event) {
        if (!event.getLevel().isClientSide()) {
            alchemy_seed = Objects.requireNonNull(Objects.requireNonNull(event.getLevel().getServer()).getLevel(Level.OVERWORLD)).getSeed();
            ReactiveMod.REACTION_MAN.reset();
        }
    }

    public record AlchemySeedConfigurationTask(ServerConfigurationPacketListener listener) implements ICustomConfigurationTask
    {
        public static final ConfigurationTask.Type TYPE = new ConfigurationTask.Type(ReactiveMod.location("alchemy_seed_config_task"));

        public void run(Consumer<CustomPacketPayload> consumer) {
            consumer.accept(new AlchemySeedData(alchemy_seed));
            this.listener().finishCurrentTask(TYPE);
        }

        public ConfigurationTask.Type type() {
            return TYPE;
        }
    }

    public static class AlchemySeedPayloadHandler
    implements IPayloadHandler<AlchemySeedData> {
        public void handle(@NotNull AlchemySeedData data, @NotNull IPayloadContext context) {
            context.enqueueWork(() -> {
                alchemy_seed = data.seed();
                ReactiveMod.REACTION_MAN.reset();
            });
        }
    }

    public record AlchemySeedData(long seed) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<AlchemySeedData> TYPE = new CustomPacketPayload.Type(ReactiveMod.location("seed_sync_payload"));
        public static final StreamCodec<ByteBuf, AlchemySeedData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, AlchemySeedData::seed, AlchemySeedData::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

