/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import tnt.tarkovcraft.core.util.Codecs;
import tnt.tarkovcraft.medsystem.common.health.PositionedAABB;
import tnt.tarkovcraft.medsystem.common.health.transform.HitboxTransformDefinition;
import tnt.tarkovcraft.medsystem.util.MedsystemCodecs;

public final class BodyPartHitbox {
    public static final Codec<BodyPartHitbox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("owner").forGetter(BodyPartHitbox::getOwner), (App)Codecs.list(HitboxTransformDefinition.CODEC).optionalFieldOf("transforms", Collections.emptyList()).forGetter(t -> t.transforms), (App)Vec3.CODEC.fieldOf("pos").forGetter(t -> t.aabb.center()), (App)MedsystemCodecs.VEC2_CODEC.fieldOf("size").forGetter(t -> t.aabb.size())).apply((Applicative)instance, BodyPartHitbox::new));
    private final String owner;
    private final List<HitboxTransformDefinition> transforms;
    private final PositionedAABB aabb;

    private BodyPartHitbox(String owner, List<HitboxTransformDefinition> transforms, Vec3 pos, Vec2 size) {
        this.owner = owner;
        this.transforms = transforms;
        this.aabb = PositionedAABB.create(pos, size);
    }

    public PositionedAABB transform(LivingEntity ctx) {
        PositionedAABB positionedAABB = this.aabb;
        for (HitboxTransformDefinition transform : this.transforms) {
            positionedAABB = transform.apply(positionedAABB, ctx);
        }
        return positionedAABB;
    }

    public AABB getLevelPositionedAABB(LivingEntity ctx) {
        return this.transform(ctx).move(ctx.position()).aabb();
    }

    public String getOwner() {
        return this.owner;
    }
}

