/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.item;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import tnt.tarkovcraft.core.common.skill.SkillSystem;
import tnt.tarkovcraft.core.util.helper.TextHelper;
import tnt.tarkovcraft.medsystem.api.heal.EffectRecovery;
import tnt.tarkovcraft.medsystem.api.heal.HealItemAttributes;
import tnt.tarkovcraft.medsystem.api.heal.HealthRecovery;
import tnt.tarkovcraft.medsystem.api.heal.Surgery;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HealthContainerDefinition;
import tnt.tarkovcraft.medsystem.common.health.HealthSystem;
import tnt.tarkovcraft.medsystem.common.health.Limb;
import tnt.tarkovcraft.medsystem.common.health.LimbType;
import tnt.tarkovcraft.medsystem.common.init.MedSystemItemComponents;
import tnt.tarkovcraft.medsystem.common.init.MedSystemSkillEvents;
import tnt.tarkovcraft.medsystem.common.item.InteractableItem;
import tnt.tarkovcraft.medsystem.common.item.InteractionTarget;
import tnt.tarkovcraft.medsystem.common.item.SimpleHealingItem;
import tnt.tarkovcraft.medsystem.common.status.BloodData;
import tnt.tarkovcraft.medsystem.common.status.BloodSystem;
import tnt.tarkovcraft.medsystem.network.message.S2C_OpenBodyPartSelectScreen;

public class HealingItem
extends InteractableItem {
    private UseAnim selfUseAnimation = UseAnim.BOW;
    private UseAnim otherUseAnimation = UseAnim.BOW;

    public HealingItem(Item.Properties properties) {
        super(properties);
    }

    public HealingItem withUseAnimations(UseAnim selfUseAnimation, UseAnim otherUseAnimation) {
        this.selfUseAnimation = Objects.requireNonNull(selfUseAnimation);
        this.otherUseAnimation = Objects.requireNonNull(otherUseAnimation);
        return this;
    }

    @Override
    protected boolean canUseItem(ItemStack itemStack, LivingEntity target, LivingEntity origin) {
        if (!super.canUseItem(itemStack, target, origin)) {
            return false;
        }
        if (!HealthSystem.hasCustomHealth((Entity)target)) {
            return false;
        }
        HealItemAttributes attributes = this.getHealingAttributes(itemStack);
        if (attributes == null) {
            return false;
        }
        return attributes.canUseOn(target, origin, itemStack, HealthSystem.getHealthData(target));
    }

    @Override
    protected boolean tryInitiateExistingInteraction(ItemStack itemStack, InteractionTarget interaction, LivingEntity target, Player origin) {
        HealthContainer container = HealthSystem.getHealthData(target);
        HealItemAttributes attributes = this.getHealingAttributes(itemStack);
        if (attributes == null) {
            return false;
        }
        return !origin.isCrouching() && (attributes.applyGlobally() || container.hasLimb(interaction.limbCode()));
    }

    @Override
    protected InteractionResult initiateInteraction(ItemStack itemStack, InteractionTarget.Mutable interaction, LivingEntity target, Player origin) {
        HealItemAttributes attributes = this.getHealingAttributes(itemStack);
        if (!attributes.applyGlobally()) {
            Level level = origin.level();
            if (interaction.isSelf() && !origin.isCrouching()) {
                this.selectBodyPart(interaction, itemStack, target);
            }
            if (interaction.isLimbSelected()) {
                this.setActiveInteraction(itemStack, interaction.toImmutable());
                return InteractionResult.SUCCESS;
            }
            if (!level.isClientSide()) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)origin), (CustomPacketPayload)new S2C_OpenBodyPartSelectScreen(interaction), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected boolean updateInteraction(Level level, ItemStack itemStack, InteractionTarget interaction, LivingEntity target, LivingEntity origin, int remainingUseTicks) {
        HealItemAttributes attributes = this.getHealingAttributes(itemStack);
        if (attributes == null) {
            return false;
        }
        HealthRecovery healthRecovery = attributes.health();
        if (healthRecovery == null) {
            return true;
        }
        int useDuration = this.getUseDuration(itemStack, origin);
        int usageTimeElapsed = useDuration - remainingUseTicks + 1;
        if (usageTimeElapsed % healthRecovery.cycleDuration() == 0) {
            int cycleLimit = healthRecovery.maxCycles() == 0 ? Integer.MAX_VALUE : healthRecovery.cycleDuration();
            int cycleIndex = usageTimeElapsed / healthRecovery.cycleDuration();
            if (cycleIndex < cycleLimit) {
                float leftover;
                Limb part;
                float amount = healthRecovery.healthPerCycle();
                HealthContainer container = HealthSystem.getHealthData(target);
                InteractionTarget activeInteraction = this.getActiveInteraction(itemStack);
                Limb limb = part = activeInteraction != null && TextHelper.isNotBlank((String)activeInteraction.limbCode()) && container.hasLimb(activeInteraction.limbCode()) ? container.getLimb(activeInteraction.limbCode()) : null;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    SkillSystem.triggerAndSynchronize(MedSystemSkillEvents.HEALING_USED, (Entity)origin);
                    if (itemStack.isDamageableItem()) {
                        itemStack.hurtAndBreak(1, serverLevel, origin, item -> origin.onEquippedItemBroken(item, EquipmentSlot.MAINHAND));
                    } else {
                        itemStack.consume(1, origin);
                    }
                }
                if ((leftover = container.heal(target, amount, part)) == amount) {
                    origin.useItemRemaining = 0;
                }
                if (leftover > 0.0f && container.canHeal(null, false)) {
                    container.heal(target, amount, null);
                }
                if (!interaction.self() && target instanceof Player) {
                    Player player = (Player)target;
                    BloodData bloodData = BloodSystem.getBloodData((LivingEntity)player);
                    BloodData.UnconsciousInfo info = bloodData.getUnconsciousInfo();
                    if (bloodData.isUnconscious() && info.causesDeath()) {
                        bloodData.setUnconsciousTime(100, BloodData.UnconsciousInfo.PAIN);
                        bloodData.sync((LivingEntity)player);
                    }
                }
                container.updateHealth(target);
                if (cycleIndex + 1 > cycleLimit || part != null && !attributes.canUseOnPart(part, itemStack, container, interaction.self(), target)) {
                    origin.useItemRemaining = 0;
                } else {
                    HealthSystem.synchronizeEntity(target);
                }
            }
        }
        return !itemStack.isEmpty();
    }

    @Override
    protected ItemStack finishInteraction(ItemStack itemStack, InteractionTarget interaction, LivingEntity target, LivingEntity origin) {
        HealItemAttributes attributes = this.getHealingAttributes(itemStack);
        String targetLimb = interaction.limbCode();
        if (!attributes.applyGlobally() && TextHelper.isBlank((String)interaction.limbCode())) {
            return itemStack;
        }
        HealthContainer container = HealthSystem.getHealthData(target);
        Limb part = container.hasLimb(targetLimb) ? container.getLimb(targetLimb) : null;
        int consume = 0;
        if (attributes.isSurgeryItem()) {
            Surgery surgery = attributes.surgery();
            ++consume;
            if (part.isDead()) {
                SkillSystem.trigger(MedSystemSkillEvents.LIMB_FIXED, (Entity)origin);
                part.setHealth(surgery.healthAfterHeal());
                surgery.addRecoveryAttributes(target, part);
            }
        }
        List<EffectRecovery> recoveries = attributes.recoveries();
        for (EffectRecovery recovery : recoveries) {
            if (!recovery.canRecover(container, part) || !HealingItem.checkDurability(itemStack, consume + recovery.consumption())) continue;
            recovery.recover(target, container, part);
            consume += recovery.consumption();
        }
        Level level = origin.level();
        if (!level.isClientSide()) {
            int consumeAmount = Math.max(1, consume);
            SkillSystem.triggerAndSynchronize(MedSystemSkillEvents.HEALING_USED, (Entity)origin, (float)consumeAmount);
            if (itemStack.isDamageableItem()) {
                itemStack.hurtAndBreak(consumeAmount, (ServerLevel)level, origin, item -> origin.onEquippedItemBroken(item, EquipmentSlot.MAINHAND));
            } else {
                itemStack.consume(1, origin);
            }
        }
        container.updateHealth(target);
        HealthSystem.synchronizeEntity(target);
        return itemStack;
    }

    @Override
    protected boolean canInteractWithEntity(ItemStack stack, LivingEntity entity, LivingEntity origin) {
        HealthContainer container = HealthSystem.getHealthData(entity);
        HealthContainerDefinition definition = container.getDefinition();
        return !definition.getDisplayConfiguration().isEmpty();
    }

    @Override
    protected boolean shouldClearInteractionDataOnCancellation(ItemStack itemStack, LivingEntity entity, int count) {
        InteractionTarget interaction = this.getActiveInteraction(itemStack);
        return interaction != null && !interaction.self();
    }

    @Override
    @Nullable
    protected Component getInteractionLabel(ItemStack itemStack, InteractionTarget interaction, LivingEntity target, LivingEntity origin, int time, boolean infinite) {
        return SimpleHealingItem.getCommonInteractionLabel(interaction, target, time, infinite);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        HealItemAttributes attributes = (HealItemAttributes)stack.get(MedSystemItemComponents.HEAL_ATTRIBUTES);
        return attributes.getUseDuration(72000);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        InteractionTarget interaction = this.getActiveInteraction(stack);
        return interaction != null && !interaction.self() ? this.otherUseAnimation : this.selfUseAnimation;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return false;
    }

    public int getBarColor(ItemStack stack) {
        return 0xFF0000;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add(SimpleHealingItem.getCommonDurabilityLabel(stack));
    }

    public static boolean checkDurability(ItemStack stack, int durabilityUse) {
        int maxDamage = Math.max(stack.getMaxDamage(), 1) - stack.getDamageValue();
        return durabilityUse <= maxDamage;
    }

    private HealItemAttributes getHealingAttributes(ItemStack itemStack) {
        return (HealItemAttributes)itemStack.get(MedSystemItemComponents.HEAL_ATTRIBUTES);
    }

    private void selectBodyPart(InteractionTarget.Mutable activeTarget, ItemStack itemStack, LivingEntity entity) {
        HealthContainer container = HealthSystem.getHealthData(entity);
        HealItemAttributes attributes = this.getHealingAttributes(itemStack);
        List<BodyPartWithPriority> bodyParts = container.getLimbsAsStream().map(part -> new BodyPartWithPriority((Limb)part, part.isVital() ? 1.5f : 1.0f)).toList();
        if (attributes.isSurgeryItem()) {
            bodyParts.forEach(this::addSurgeryHealingPriorities);
        }
        if (attributes.isRecoveryItem()) {
            bodyParts.forEach(part -> this.addStatusEffectHealingPriorities((BodyPartWithPriority)part, attributes.recoveries(), container));
        }
        if (attributes.isHealing()) {
            bodyParts.forEach(this::addHealthHealingPriorities);
        }
        bodyParts.stream().filter(BodyPartWithPriority::isViable).max(Comparator.comparingInt(BodyPartWithPriority::priority)).ifPresent(priorityPart -> activeTarget.setLimbCode(priorityPart.limb.getLimbCode()));
    }

    private void addSurgeryHealingPriorities(BodyPartWithPriority part) {
        if (part.limb.isDead()) {
            LimbType group = part.limb.getType();
            part.add(1000 + group.getSurgeryHealingPriority());
        }
    }

    private void addStatusEffectHealingPriorities(BodyPartWithPriority part, List<EffectRecovery> recoveries, HealthContainer container) {
        Set uniqueTypes;
        Limb limb = part.limb;
        ArrayList<StatusEffect> statusEffects = new ArrayList<StatusEffect>(limb.getStatusEffects().listEffects());
        if (limb == container.getRootLimb()) {
            statusEffects.addAll(container.getGlobalStatusEffects().listEffects());
        }
        if (!(uniqueTypes = statusEffects.stream().map(StatusEffect::getType).collect(Collectors.toSet())).isEmpty()) {
            for (EffectRecovery recovery : recoveries) {
                StatusEffectType type = (StatusEffectType)recovery.effect().value();
                if (!uniqueTypes.contains(type)) continue;
                part.add(type.getHealingPriority());
            }
        }
    }

    private void addHealthHealingPriorities(BodyPartWithPriority part) {
        Limb limb = part.limb;
        float missingAmount = limb.getMaxHealAmount();
        if (!limb.isDead() && missingAmount > 0.0f) {
            part.add(Mth.ceil((float)(5.0f * missingAmount)));
        }
    }

    private static final class BodyPartWithPriority {
        private final Limb limb;
        private final float multiplier;
        private int priority;

        public BodyPartWithPriority(Limb limb, float multiplier) {
            this.limb = limb;
            this.multiplier = multiplier;
        }

        private void add(int amount) {
            this.priority += Mth.ceil((float)((float)amount * this.multiplier));
        }

        private boolean isViable() {
            return this.priority > 0;
        }

        private int priority() {
            return this.priority;
        }

        public String toString() {
            return this.limb.getLimbCode() + ": " + this.priority;
        }
    }
}

