/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.config;

import dev.toma.configuration.config.Configurable;
import tnt.tarkovcraft.core.common.data.duration.Duration;
import tnt.tarkovcraft.medsystem.common.config.ItemStatusEffectConfig;

public final class StatusEffectConfig {
    @Configurable
    @Configurable.Comment(value={"Enables hit effects such as bleeds, fractures and other effects"})
    @Configurable.Synchronized
    public boolean enableStatusEffects = true;
    @Configurable
    @Configurable.Comment(value={"Enables transferring of status effects from items/projectiles to hit entities"})
    public boolean enableItemDamageStatusEffects = true;
    @Configurable
    @Configurable.Range(min=200L)
    @Configurable.Comment(value={"Default duration of item/projectile side effects"})
    public int itemStatusEffectDuration = Duration.minutes((int)2).tickValue();
    @Configurable
    @Configurable.Synchronized
    @Configurable.DecimalRange(min=0.0010000000474974513)
    @Configurable.Comment(value={"Blood loss per minute for light bleeds"})
    public float lightBleedAmount = 0.1f;
    @Configurable
    @Configurable.Synchronized
    @Configurable.DecimalRange(min=0.0010000000474974513)
    @Configurable.Comment(value={"Blood loss per minute for heavy bleeds"})
    public float heavyBleedAmount = 1.0f;
    @Configurable
    @Configurable.Comment(value={"Base chance for getting any type of bleed from '#medsystem:bleed_causing' damage type"})
    @Configurable.DecimalRange(min=0.0, max=1.0)
    @Configurable.Gui.NumberFormat(value="0.0##")
    @Configurable.Gui.Slider
    public float playerBleedChance = 0.025f;
    @Configurable
    @Configurable.Comment(value={"Base chance for getting fracture from '#medsystem:fracture' damage type"})
    @Configurable.DecimalRange(min=0.0, max=1.0)
    @Configurable.Gui.NumberFormat(value="0.0##")
    @Configurable.Gui.Slider
    public float playerFractureChance = 0.03f;
    @Configurable
    @Configurable.Comment(value={"Base chance for getting fracture from '#minecraft:is_fall' damage type"})
    @Configurable.DecimalRange(min=0.0, max=1.0)
    @Configurable.Gui.NumberFormat(value="0.0##")
    @Configurable.Gui.Slider
    public float playerFractureFallChance = 0.035f;
    @Configurable
    @Configurable.Comment(value={"Scaling function for 'Fall fracture chance' value", "Formula: (SCALE * fallDistance) * baseChance"})
    public float playerFractureFallDistanceScale = 0.75f;
    @Configurable
    public ItemStatusEffectConfig swordStatusEffects = new ItemStatusEffectConfig(0.1f, 0.04f, 0.0f);
    @Configurable
    public ItemStatusEffectConfig axeStatusEffects = new ItemStatusEffectConfig(0.1f, 0.02f, 0.1f);
    @Configurable
    public ItemStatusEffectConfig bluntStatusEffects = new ItemStatusEffectConfig(0.05f, 0.0f, 0.1f);
}

