/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import tnt.tarkovcraft.medsystem.common.effect.LightBleedStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.effect.util.StatusEffectSubmitter;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.init.MedSystemStatusEffects;

public class FreshWoundStatusEffect
extends StatusEffect {
    public static final MapCodec<FreshWoundStatusEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> FreshWoundStatusEffect.common(instance).and((App)Codec.FLOAT.optionalFieldOf("bleedChance", (Object)Float.valueOf(0.0f)).forGetter(t -> Float.valueOf(t.bleedChance))).apply((Applicative)instance, FreshWoundStatusEffect::new));
    private static final Component INFO = Component.translatable((String)"status_effect.medsystem.fresh_wound.info").withStyle(ChatFormatting.DARK_GRAY);
    private float bleedChance;

    public FreshWoundStatusEffect(int duration) {
        this(duration, 0.0f);
    }

    public FreshWoundStatusEffect(int duration, float bleedChance) {
        super(duration);
        this.bleedChance = bleedChance;
    }

    public static FreshWoundStatusEffect createTemplate() {
        return new FreshWoundStatusEffect(-1);
    }

    @Override
    public void apply(HealthContainer container, LivingEntity entity, @Nullable BodyPart limb) {
        if (entity.isSprinting()) {
            this.bleedChance += 3.5E-4f;
            if (this.bleedChance >= 1.0f) {
                this.markForRemoval();
            }
        }
    }

    @Override
    public void onRemoved(StatusEffectSubmitter submitter, HealthContainer container, LivingEntity entity, @Nullable BodyPart limb) {
        RandomSource source = entity.getRandom();
        if (source.nextFloat() < this.bleedChance) {
            submitter.submitImmediate(new LightBleedStatusEffect(-1));
        }
    }

    @Override
    public StatusEffect copy() {
        return new FreshWoundStatusEffect(this.getDuration(), this.bleedChance);
    }

    @Override
    public void addAdditionalInfo(Consumer<Component> tooltip) {
        tooltip.accept(INFO);
    }

    @Override
    public StatusEffectType<?> getType() {
        return (StatusEffectType)MedSystemStatusEffects.FRESH_WOUND.value();
    }
}

