/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.effect;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import tnt.tarkovcraft.medsystem.MedicalSystem;
import tnt.tarkovcraft.medsystem.common.effect.BleedStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.init.MedSystemStatusEffects;

public class LightBleedStatusEffect
extends BleedStatusEffect {
    public static final MapCodec<LightBleedStatusEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> LightBleedStatusEffect.commonEntity(instance).apply((Applicative)instance, LightBleedStatusEffect::new));
    private static final Component HINT = Component.translatable((String)"status_effect.medsystem.light_bleed.heal_hint").withStyle(ChatFormatting.DARK_GRAY);

    public LightBleedStatusEffect(int duration, Optional<UUID> owner) {
        super(duration);
    }

    public LightBleedStatusEffect(int duration) {
        super(duration);
    }

    public static LightBleedStatusEffect createTemplate() {
        return new LightBleedStatusEffect(-1);
    }

    @Override
    public long getDamageInterval() {
        return 60L;
    }

    @Override
    public float getDamageAmount() {
        return 0.5f;
    }

    @Override
    public float getPerMinuteBloodLossAmount(LivingEntity entity) {
        return MedicalSystem.getConfig().statusEffects.lightBleedAmount;
    }

    @Override
    public StatusEffect copy() {
        return new LightBleedStatusEffect(this.getDuration());
    }

    @Override
    public void addAdditionalInfo(Consumer<Component> tooltip) {
        tooltip.accept(HINT);
    }

    @Override
    public StatusEffectType<?> getType() {
        return (StatusEffectType)MedSystemStatusEffects.LIGHT_BLEED.value();
    }
}

